<?php

namespace CocktailRecipes\Core\Admin;

class Textarea extends Field
{
    protected const AUTO_RENDER_LABEL = false;
    protected const NOTE_SPACER = false;

    protected function renderInput(array $options): void
    {
        switch ($this->data['type']) {
            case 'markdown':
                $class2 = ($options['style'] ?? '') == 'regular' ? '' : 'code';
                break;
            default:
                $class2 = ($options['style'] ?? '') == 'code' ? 'code' : '';
        }
        $maxlen = $this->data['maxlen'] ?? null;
        $rows   = $this->data['rows'] ?? 10;
        $cols   = $this->data['cols'] ?? 50;

        $hasLabel = isset($this->options['label']);
        ?>
        <fieldset>
            <?php if ($hasLabel): ?>
                <p><?php $this->renderLabel(); ?></p>
            <?php endif; ?>
            <p><textarea class="large-text <?php echo esc_attr($class2); ?>"
                rows="<?php echo esc_attr($rows); ?>" cols="<?php echo esc_attr($cols); ?>"
                <?php $this->name(); ?>
                <?php $this->id(); ?>
                <?php if ($maxlen !== null) echo 'maxlength="' . esc_attr($maxlen) . '"'; ?>
                <?php $this->required(); ?>
                <?php $this->placeholder(); ?>
                ><?php echo esc_textarea($this->data['value']); ?></textarea>
            </p>
        </fieldset>
        <?php
    }
}
