<?php

namespace CocktailRecipes\Core\Admin;

class TextField extends Field
{
    protected const LABEL_INPUT_WRAPPER = true;

    protected function renderInput(array $options): void
    {
        $minlen = $maxlen = $pattern = null;
        switch ($type = $this->data['type']) {
            case 'url':
                $class2 = 'code';
                break;
            case 'email':
                $class2 = 'ltr';
                break;
            default:
                $type    = 'text';
                $class2  = ($options['style'] ?? '') == 'code' ? 'code' : '';
                $minlen  = $this->data['minlen'] ?? null;
                $maxlen  = $this->data['maxlen'] ?? null;
                $pattern = $this->data['pattern'] ?? null;
        }
        $showVal = $this->data['isset'] || isset($this->data['default']);
        ?>
        <input type="<?php echo esc_attr($type); ?>" class="regular-text <?php echo esc_attr($class2); ?>"
            <?php $this->name(); ?>
            <?php $this->id(); ?>
            <?php if ($minlen !== null) echo 'minlength="' . esc_attr($minlen) . '"'; ?>
            <?php if ($maxlen !== null) echo 'maxlength="' . esc_attr($maxlen) . '"'; ?>
            <?php if ($pattern !== null) echo 'pattern="' . esc_attr($pattern) . '"'; ?>
            <?php $this->required(); ?>
            <?php $this->placeholder(); ?>
            <?php if ($showVal) $this->value(); ?>> <?php echo esc_html($options['text'] ?? '') ?>
        <?php
    }
}
