<?php

namespace CocktailRecipes\Core\Admin;

class SelectField extends Field
{
    protected const LABEL_INPUT_WRAPPER = true;

    protected function renderInput(array $options): void
    {
        $currentValue = $this->data['value'];
        if ($this->data['type'] == 'bool') $currentValue = $currentValue ? '1' : '0';
        ?>
        <select <?php $this->name(); ?> <?php $this->id() ?> <?php $this->required(); ?>>
            <?php foreach ($options['values'] as $value => $text): ?>
                <option <?php selected($value, $currentValue); ?>
                    <?php $this->value($value); ?>> <?php echo esc_html($text) ?></option>
            <?php endforeach; ?>
        </select> <?php echo esc_html($options['text'] ?? '') ?>
        <?php
    }
}
