<?php

namespace CocktailRecipes\Core\Admin;

class RadioField extends Field
{
    protected function renderInput(array $options): void
    {
        $currentValue = $this->data['value'];
        if ($this->data['type'] == 'bool') $currentValue = $currentValue ? '1' : '0';
        ?>
        <fieldset>
            <p>
            <?php foreach ($options['values'] as $value => $text): ?>
                <?php $this->br(); ?>
                <label>
                    <input type="radio"
                        <?php $this->name(); ?>
                        id="<?php echo esc_attr($this->group . '__' . $this->field . '__' . $value); ?>"
                        <?php checked($value, $currentValue); ?>
                        <?php $this->required(); ?>
                        <?php $this->value($value); ?>> <?php echo esc_html($text) ?>
                </label>
            <?php endforeach; ?>
            </p>
        </fieldset>
        <?php
    }
}
