<?php

namespace CocktailRecipes\Core\Admin;

class NumberField extends Field
{
    protected const LABEL_INPUT_WRAPPER = true;

    protected function renderInput(array $options): void
    {
        $min  = $this->data['min'] ?? null;
        $max  = $this->data['max'] ?? null;
        $step = $this->data['step'] ?? null;

        $showVal = $this->data['isset'] || isset($this->data['default']);
        ?>
        <input type="number" class="small-text"
            <?php $this->name(); ?>
            <?php $this->id(); ?>
            <?php if ($min !== null) echo 'min="' . esc_attr($min) . '"'; ?>
            <?php if ($max !== null) echo 'max="' . esc_attr($max) . '"'; ?>
            <?php if ($step !== null) echo 'step="' . esc_attr($step) . '"'; ?>
            <?php $this->required(); ?>
            <?php $this->placeholder(); ?>
            <?php if ($showVal) $this->value(); ?>> <?php echo esc_html($options['text'] ?? '') ?>
        <?php
    }
}
