<?php

namespace CocktailRecipes\Core\Admin;

class Checkbox extends Field
{
    protected function renderInput(array $options): void
    {
        ?>
        <input type="hidden"
            name="<?php echo esc_attr($this->group); ?>[ck__<?php echo esc_attr($this->field); ?>]"
            value="1">
        <input type="checkbox"
            <?php $this->name(); ?>
            <?php $this->id(); ?>
            <?php checked(!empty($this->data['value'])); ?>
            <?php $this->required(); ?>
            value="1"> <?php echo esc_html($options['text'] ?? '') ?>
        <?php
    }
}
