<?php

namespace CocktailRecipes\Admin;

use CocktailRecipes\Core\Admin\Tab;

class SettingsTab extends Tab
{

    public function init(): void
    {
        $this->title = __('Settings', 'cocktail-recipes');
    }

    public function initContent(): void
    {
        $this->addSettings('general');

        // Display Settings
        $this->addSection(
            __('Display Settings', 'cocktail-recipes'),
            __('Controls where and how cocktail recipes are rendered.', 'cocktail-recipes')
        );
        $this->addInput(__('Default Post View', 'cocktail-recipes'), 'default_post_view', [
            'values' => [
                'short'     => __('Summary', 'cocktail-recipes'),
                'full'      => __('Full Instructions', 'cocktail-recipes'),
                'only-full' => __('Full Instructions (no toggle)', 'cocktail-recipes'),
            ]
        ]);
        $this->addInput(__('Default List View', 'cocktail-recipes'), 'default_list_view', [
            'values' => [
                'short'      => __('Summary', 'cocktail-recipes'),
                'full'       => __('Full Instructions', 'cocktail-recipes'),
                'only-short' => __('Summary (no toggle)', 'cocktail-recipes'),
            ]
        ]);
        $this->addInputs(__('Page Types Enabled', 'cocktail-recipes'), [
            'show_on_home' => [
                'text' => __('Display on home page', 'cocktail-recipes')
            ],
            'show_on_lists' => [
                'text' => __('Display on list page (categories, tags, archives)', 'cocktail-recipes')
            ],
            'show_on_search' => [
                'text' => __('Display in search results', 'cocktail-recipes'),
                'note' => __(
                    'Recipes are always displayed on posts and pages.',
                    'cocktail-recipes'
                ),
            ],
        ]);
        $this->addInputs(__('Features Shown', 'cocktail-recipes'), [
            'show_attribution' => [
                'text' => __('Show an attribution link', 'cocktail-recipes')
            ],
            'show_errors' => [
                'text' => __('Show recipe errors to editor/admin users', 'cocktail-recipes')
            ],
            'show_metadata' => [
                'text' => __('Show metadata (cache info, timing, etc.) to admin users', 'cocktail-recipes'),
            ],
        ]);

        // Recipe Controls
        $this->addSection(
            __('Recipe Controls', 'cocktail-recipes'),
            __('Adjustments for the controls at the bottom of each recipe.', 'cocktail-recipes')
        );
        $this->addInput(__('Control Labels', 'cocktail-recipes'), 'control_labels', [
            'label' => __('Labels before cocktail controls:', 'cocktail-recipes'),
            'style' => 'select',
            'values' => [
                'always'  => __('Always displayed', 'cocktail-recipes'),
                'desktop' => __('Not displayed on small screens', 'cocktail-recipes'),
                'never'   => __('Not displayed', 'cocktail-recipes'),
            ]
        ]);
        $this->addInput(__('Servings', 'cocktail-recipes'), 'enable_servings', [
            'text' => __('Include serving size selection', 'cocktail-recipes'),
        ]);
        $this->addInputs(__('Units', 'cocktail-recipes'), [
            'default_units' => [
                'label' => __('Default units', 'cocktail-recipes'),
                'note'  => __(
                    'When set to auto, default units selected based on locale.',
                    'cocktail-recipes'
                ),
                'style' => 'select',
                'values' => [
                    'auto' => __('Auto', 'cocktail-recipes'),
                    'oz' => __('oz', 'cocktail-recipes'),
                    'ml' => __('mL', 'cocktail-recipes'),
                    'cl' => __('cL', 'cocktail-recipes'),
                    'cc' => __('cc', 'cocktail-recipes'),
                ],
            ],
            'enable_cl' => [
                'text' => __('Enable cubic centiliter (cL)', 'cocktail-recipes'),
            ],
            'enable_cc' => [
                'text' => __('Enable cubic centimeters (cc)', 'cocktail-recipes'),
            ],
        ]);
        $this->addInputs(__('List View Link', 'cocktail-recipes'), [
            'list_view_link' => [
                'label' => __('Link type:', 'cocktail-recipes'),
                'style' => 'select',
                'values' => [
                    ''     => __('No link added', 'cocktail-recipes'),
                    'card' => __('Make entire recipe clickable', 'cocktail-recipes'),
                    'btn'  => __('Add button linking to post', 'cocktail-recipes'),
                    'text' => __('Add text link to post', 'cocktail-recipes'),
                ],
            ],
            'list_view_link_pos' => [
                'label'  => __('Link position:', 'cocktail-recipes'),
                'style' => 'select',
                'values' => [
                    'left'   => _x('Left', 'Link position', 'cocktail-recipes'),
                    'center' => _x('Center', 'Link posiion', 'cocktail-recipes'),
                    'right'  => _x('Right', 'Link position', 'cocktail-recipes'),
                ],
            ],
            'list_view_link_text' => [
                'label' => __('Link text:', 'cocktail-recipes'),
                'hint'  => GeneralSettings::defaultLinkText(),
                'note'  => __('When a recipe is shown in a list without controls, these settings control if a link to the post is included.', 'cocktail-recipes'),
            ],
        ]);
    }
}
