<?php

namespace CocktailRecipes\Admin;

use CocktailRecipes\Core\Admin\Page;

class SettingsPage extends Page
{
    protected function init(): void
    {
        $this->title = __('Cocktail Recipes Settings', 'cocktail-recipes');
        $this->menuTitle = __('Cocktail Recipes', 'cocktail-recipes');
    }

    protected function initContent(): void
    {
        $this->setTabs([
            new SettingsTab('settings'),
            new ReferenceTab('reference'),
            new AdvancedTab('advanced'),
        ]);

        $this->addFooter(sprintf(
            /* translators: %s is a clickable link */
            __(
                'Enjoying Cocktail Recipes? %s to help support future development!',
                'cocktail-recipes'
            ),
            '<a href="https://buymeacoffee.com/iangoldstein" target="blank" rel="noopener noreferrer">'
                . __('Buy me a coffee', 'cocktail-recipes')
                . '</a>'
        ));
    }
}
