<?php

namespace CocktailRecipes\Admin;

use CocktailRecipes\Core\Admin\Settings;

class GeneralSettings extends Settings
{
    public const OPTION_NAME = 'cocktail_recipes_general';

    protected const FIELDS = [

        'show_on_home' => 'bool',
        'show_on_lists' => 'bool',
        'show_on_search' => 'bool',

        'default_post_view' => [
            'type'    => 'enum',
            'values'  => ['short', 'full', 'only-full'],
            'default' => 'short',
        ],
        'default_list_view' => [
            'type'    => 'enum',
            'values'  => ['short', 'full', 'only-short'],
            'default' => 'only-short',
        ],

        'list_view_link' => [
            'type' => 'enum',
            'values' => ['', 'card', 'btn', 'text'],
            'default' => 'card',
        ],
        'list_view_link_pos' => [
            'type'    => 'enum',
            'values'  => ['left', 'center', 'right'],
            'default' => 'right',
        ],
        'list_view_link_text' => [
            'type' => 'text',
        ],

        'control_labels' => [
            'type'   => 'enum',
            'values' => ['always', 'desktop', 'never'],
            'default' => 'always',
        ],

        'enable_servings' => [
            'type' => 'bool',
            'default' => true,
        ],

        'default_units' => [
            'type'    => 'enum',
            'values'  => ['auto', 'oz', 'ml', 'cl', 'cc'],
            'default' => 'auto',
        ],
        'enable_cl' => [
            'type' => 'bool',
            'default' => true,
        ],
        'enable_cc' => [
            'type' => 'bool',
            'default' => true,
        ],

        'show_attribution' => 'bool',
        'show_errors' => [
            'type' => 'bool',
            'default' => true,
        ],
        'show_metadata' => 'bool',
    ];

    protected function validateFields(array $output): array
    {
        // If default_units is cl or cc but the corresponding enable flag is false, reset to auto
        if (isset($output['default_units'])) {
            if ($output['default_units'] === 'cl' && empty($output['enable_cl'])) {
                $output['default_units'] = 'auto';
            }
            if ($output['default_units'] === 'cc' && empty($output['enable_cc'])) {
                $output['default_units'] = 'auto';
            }
        }

        return $output;
    }

    public static function defaultLinkText(): string
    {
        return __("View Full Recipe \u{2192}", 'cocktail-recipes');
    }
}
