<?php

namespace CocktailRecipes\Admin;

use CocktailRecipes\Core\Admin\Action;
use CocktailRecipes\Core\Helpers\Cache;
use CocktailRecipes\Shortcodes\CocktailShortcode;

class ClearRecipesAction extends Action
{
    protected const REDIRECT = ['options-general.php', 'cocktail-recipes', 'advanced'];

    protected static function execute(): ?string
    {
        return Cache::clear(CocktailShortcode::RECIPE_CACHE_PREFIX) > 0
            ? 'recipes-cleared'
            : null;
    }
}
