<?php

/**
 * Cocktail Recipes
 *
 * @package     Cocktail_Recipes
 * @author      Ian S. Goldstein (https://www.isgdev.com)
 * @copyright   2025 Ian S. Goldstein
 * @link        https://www.isgdev.com/software/cocktail-recipes
 * @license     GPL-2.0-or-later
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 * See license.txt in the project root for license details.
 *
 * @wordpress-plugin
 * Plugin Name: Cocktail Recipes
 * Plugin URI: https://www.isgdev.com/software/cocktail-recipes
 * Description: Elegant, structured cocktail recipe rendering via shortcode, with automatic formatting and unit conversion for mixology enthusiasts.
 * Version: 1.1.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Ian S. Goldstein
 * Author URI: https://www.isgdev.com
 * Text Domain: cocktail-recipes
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) exit;

// For debugging use only...
#define('COCKTAIL_RECIPES_NO_CACHE', true);

// load and initialize plugin
require_once __DIR__ . '/includes/Plugin.php';
\CocktailRecipes\Plugin::init(
    'Cocktail Recipes',     // plugin name
    '1.1.0',                // plugin version
    'cocktail-recipes',     // plugin slug
    'cocktail-recipes',     // localization text domain
    'CocktailRecipes',      // namespace
    __FILE__                // loader file
);


// helper to get plugin instance
function cocktail_recipes(): \CocktailRecipes\Plugin
{
    return \CocktailRecipes\Plugin::instance();
}
