(function () {
    'use strict';

    // =========================================================================
    // Units Select - Enable/disable cL and cc options based on checkboxes
    // =========================================================================

    (function initUnitsSelect() {
        const selectField = document.getElementById('cocktail_recipes_general__default_units');
        const clCheckbox = document.getElementById('cocktail_recipes_general__enable_cl');
        const ccCheckbox = document.getElementById('cocktail_recipes_general__enable_cc');

        if (!selectField || !clCheckbox || !ccCheckbox) return;

        let savedSelection = null;

        function updateSelectOptions() {
            const currentValue = selectField.value;
            const clOption = selectField.querySelector('option[value="cl"]');
            const ccOption = selectField.querySelector('option[value="cc"]');

            // Handle cL option
            if (clOption) {
                if (clCheckbox.checked) {
                    clOption.disabled = false;
                    if (savedSelection === 'cl') {
                        selectField.value = 'cl';
                        savedSelection = null;
                    }
                } else {
                    clOption.disabled = true;
                    if (currentValue === 'cl') {
                        savedSelection = 'cl';
                        selectField.value = 'auto';
                    }
                }
            }

            // Handle cc option
            if (ccOption) {
                if (ccCheckbox.checked) {
                    ccOption.disabled = false;
                    if (savedSelection === 'cc') {
                        selectField.value = 'cc';
                        savedSelection = null;
                    }
                } else {
                    ccOption.disabled = true;
                    if (currentValue === 'cc') {
                        savedSelection = 'cc';
                        selectField.value = 'auto';
                    }
                }
            }
        }

        // Clear saved selection when user manually changes the select
        selectField.addEventListener('change', function () {
            savedSelection = null;
        });

        // Update options when checkboxes change
        clCheckbox.addEventListener('change', updateSelectOptions);
        ccCheckbox.addEventListener('change', updateSelectOptions);

        // Initialize on page load
        updateSelectOptions();
    })();

    // =========================================================================
    // List View Link - Enable/disable link pos/text fields based on link type
    // =========================================================================

    (function initListViewLink() {
        const linkTypeSelect = document.getElementById('cocktail_recipes_general__list_view_link');
        const linkPosField = document.getElementById('cocktail_recipes_general__list_view_link_pos');
        const linkTextField = document.getElementById('cocktail_recipes_general__list_view_link_text');

        if (!linkTypeSelect || !linkPosField || !linkTextField) return;

        function updateLinkTextState() {
            const needsMore = ['btn', 'text'].includes(linkTypeSelect.value);
            linkPosField.disabled = !needsMore;
            linkTextField.disabled = !needsMore;
        }

        linkTypeSelect.addEventListener('change', updateLinkTextState);

        // Initialize on page load
        updateLinkTextState();
    })();

})();
