<?php
/**
 * Uninstall Handler
 * 
 * Fired when the plugin is uninstalled (deleted) from WordPress admin.
 * 
 * This file:
 * - Checks if user enabled "Delete on uninstall" in Global Settings
 * - If enabled, deletes all plugin data (forms, entries, settings)
 * - If disabled, preserves all data for potential reinstall
 */

// Exit if not called from WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Load plugin constants
define('CMBSQF_PLUGIN_DIR', plugin_dir_path(__FILE__));

// Load database core to access settings
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-core.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

// Check if user wants to delete data on uninstall
$cmbsqf_delete_on_uninstall = CMBSQF_DB_Settings::get('general__data__delete_on_uninstall', 0, '0');

if ($cmbsqf_delete_on_uninstall === '1') {
    // User requested data deletion
    $cmbsqf_upload_dir = wp_upload_dir();
    $cmbsqf_plugin_data_dir = $cmbsqf_upload_dir['basedir'] . '/cmb-sqlite-form';
    
    if (is_dir($cmbsqf_plugin_data_dir)) {
        // Initialize WP_Filesystem
        require_once ABSPATH . 'wp-admin/includes/file.php';
        WP_Filesystem();
        global $wp_filesystem;
        
        if ($wp_filesystem) {
            // Use WP_Filesystem to delete directory
            $wp_filesystem->delete($cmbsqf_plugin_data_dir, true);
        }
    }
}

// If $cmbsqf_delete_on_uninstall is '0', we do nothing - data is preserved
