<?php
/**
 * Frontend REST Loader
 * 
 * Purpose: Load and register frontend REST controllers
 * Location: /rest/class-frontend-loader.php
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class CMBSQF_Frontend_Loader
 * 
 * Registers all frontend REST API endpoints
 */
class CMBSQF_Frontend_Loader {
    
    /**
     * Register all frontend REST controllers
     */
    public static function register() {
        // Load database dependencies
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-submissions.php';
        // Load Submit Controller
        require_once CMBSQF_PLUGIN_DIR . 'rest/frontend/class-submit-controller.php';
        CMBSQF_REST_Submit::register();
    }
}
