<?php
/**
 * Admin REST Loader
 *
 * Purpose: Load and register all admin REST controllers
 * Location: /rest/class-admin-loader.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class CMBSQF_Admin_Loader {

    /**
     * Register all admin REST controllers.
     */
    public static function register() {
        // Load database dependencies
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-submissions.php';
        // List of controller files to load
        $controllers = [
            'class-settings-controller.php',
            'class-forms-controller.php',
            'class-email-controller.php',
            'class-blocklist-controller.php',
            'class-entries-controller.php',
        ];

        // Load each controller
        foreach ($controllers as $file) {
            $path = CMBSQF_PLUGIN_DIR . 'rest/admin/' . $file;
            if (file_exists($path)) {
                require_once $path;
            }
        }

        // Register routes for each controller
        if (class_exists('CMBSQF_REST_Settings')) {
            CMBSQF_REST_Settings::register();
        }
        if (class_exists('CMBSQF_REST_Forms')) {
            CMBSQF_REST_Forms::register();
        }
        if (class_exists('CMBSQF_REST_Email')) {
            CMBSQF_REST_Email::register();
        }
        if (class_exists('CMBSQF_REST_Blocklist')) {
            CMBSQF_REST_Blocklist::register();
        }
        if (class_exists('CMBSQF_REST_Entries_Controller')) {
            $entries_controller = new CMBSQF_REST_Entries_Controller();
            $entries_controller->register_routes();
        }
    }

    /**
     * Check if current user has admin permissions.
     *
     * @return bool True if user can manage options.
     */
    public static function check_admin_permission() {
        return current_user_can('manage_options');
    }
}
