<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Shortcode Handler
 *
 * Purpose: Registers and renders the [cmb_sqlite_form] shortcode.
 * Location: /frontend/class-shortcode.php
 */
class CMBSQF_Shortcode {

    /**
     * Render the shortcode output.
     *
     * @param array  $atts    Shortcode attributes.
     * @param string $content Shortcode content (unused).
     * @return string HTML output.
     */
    public static function render($atts = [], $content = '') {
        // Load database dependencies
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-core.php';
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-submissions.php';

        $atts = shortcode_atts([
            'id' => 0,
        ], $atts, 'cmb_sqlite_form');
        
        $form_id = intval($atts['id']);
        
        // Validate form ID
        if ($form_id <= 0) {
            return '<div class="cmbsqf-error">' . esc_html__('Invalid form ID. Please specify a valid form ID.', 'cmb-sqlite-form') . '</div>';
        }
        
        // Check if form exists by trying to get its database
        $db = CMBSQF_DB_Core::get_form_settings_db($form_id);
        if (is_wp_error($db)) {
            return '<div class="cmbsqf-error">' . 
                   sprintf(
                       /* translators: %d: form ID */
                       esc_html__('Form #%d does not exist. Please check the form ID in your shortcode.', 'cmb-sqlite-form'),
                       $form_id
                   ) . 
                   '</div>';
        }
        $db->close();

        // Load Form Renderer
        require_once CMBSQF_PLUGIN_DIR . 'frontend/class-form-renderer.php';
        
        return CMBSQF_Form_Renderer::render($form_id);
    }
}
