<?php
/**
 * Plugin Name:       CMB SQLite Form
 * Description:       Contact forms with SQLite storage, customizable fields, email notifications, SMTP, spam protection, junk email filtering, and CSV/DB export.
 * Version:           0.9.2
 * Author:            César Morillas
 * License:           GPL-2.0-or-later
 * Text Domain:       cmb-sqlite-form
 */

if (!defined('ABSPATH')) {
    exit;
}

define('CMBSQF_VERSION', '0.9.2');
define('CMBSQF_PLUGIN_FILE', __FILE__);
define('CMBSQF_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CMBSQF_PLUGIN_URL', plugin_dir_url(__FILE__));
define('CMBSQF_ENABLE_CSS_EDITOR', false);      // Set to true to enable custom CSS editor, false to use template selector only

// Register activation hook
register_activation_hook(__FILE__, function() {
    require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-core.php';    // Create global database and initialize defaults
    CMBSQF_DB_Core::create_global_db();
});

register_deactivation_hook(CMBSQF_PLUGIN_FILE, function() {
    // Nothing to do
});

require_once CMBSQF_PLUGIN_DIR . 'includes/class-constants.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/class-context.php';

// Detect the current context (admin, frontend, AJAX, REST)
switch (CMBSQF_Context::get()) {
    case 'ajax-admin':
        // Reserved for future admin AJAX handlers (currently unused)
        break;
    case 'ajax-frontend':
        // Reserved for future frontend AJAX handlers (currently unused)
        break;
    case 'ajax-generic':
        // Reserved for context-agnostic AJAX handlers (currently unused)
        break;
    case 'rest-admin':
        add_action('rest_api_init', function() {
            require_once CMBSQF_PLUGIN_DIR . 'rest/class-admin-loader.php';
            CMBSQF_Admin_Loader::register();
        });
        break;
    case 'rest-frontend':
        add_action('rest_api_init', function() {
            require_once CMBSQF_PLUGIN_DIR . 'rest/class-frontend-loader.php';
            CMBSQF_Frontend_Loader::register();
        });
        break;
    case 'rest-generic':
        // Reserved for context-agnostic REST handlers (currently unused)
        break;
    case 'admin-post-plugin':
        // Plugin-specific admin-post.php requests (downloads, form processing)
        require_once CMBSQF_PLUGIN_DIR . 'admin-post/class-download-handler.php';
        CMBSQF_Download_Handler::register();
        break;
    case 'admin-post':
        // Generic admin-post.php requests (not from this plugin)
        break;
    case 'wp-admin':
        // WordPress admin (not plugin pages) - show menu placeholder
        require_once CMBSQF_PLUGIN_DIR . 'admin/class-menu-placeholder.php';
        CMBSQF_Menu_Placeholder::register();
        break;
    case 'wp-admin-plugin':
        // Plugin admin pages - load full admin interface
        require_once CMBSQF_PLUGIN_DIR . 'admin/class-pages.php';
        CMBSQF_Pages::register();
        break;

    default:
        // Frontend - register shortcode (lazy load handler)
        // This is a "Proxy": The file is ONLY loaded if the shortcode is actually used in content or widgets.
        add_shortcode('cmb_sqlite_form', function ($atts = [], $content = '') {
            require_once CMBSQF_PLUGIN_DIR . 'frontend/class-shortcode.php';
            return CMBSQF_Shortcode::render($atts, $content);
        });
        break;
}

function cmbsqf_deactivate() {
    // Placeholder for cleanup when deactivating.
}
