<?php
/**
 * Notifications Tab Renderer
 *
 * Purpose: Renders the Notifications tab with 4 sections (Sender, Outgoing Server, To User, To Admin)
 * Used by: Settings pages (global and form contexts)
 * Location: /admin/tabs/class-tab-notifications.php
 *
 * This tab uses the Sidebar Renderer to render a sidebar navigation with 4 sections.
 * All configuration is visible in this file - no need to check other files.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load Sidebar Renderer

// Load section classes
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-outgoing-server.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-to-user.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-to-admin.php';

/**
 * Class CMBSQF_Tab_Notifications
 *
 * Renders Notifications tab with sidebar navigation for email settings.
 */
class CMBSQF_Tab_Notifications {

    /**
     * Render the Notifications tab.
     *
     * @param int $form_id Form ID (0 for global settings, specific ID for form settings).
     */
    public static function render($form_id = 0) {
        // Define sections for this tab
        $sections = [
            /*
            'sender' => [
                'label'    => __('Sender', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('email'),
                'callback' => ['CMBSQF_Section_Sender', 'render'],
            ],
            */
            'outgoing_server' => [
                'label'    => __('Outgoing Server', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('admin-network'),
                'callback' => ['CMBSQF_Section_Outgoing_Server', 'render'],
            ],
            'to_user' => [
                'label'    => __('To User', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('groups'),
                'callback' => ['CMBSQF_Section_To_User', 'render'],
            ],
            'to_admin' => [
                'label'    => __('To Admin', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('megaphone'),
                'callback' => ['CMBSQF_Section_To_Admin', 'render'],
            ],
        ];

        // Render Sidebar Layout (Inline)
        ?>
        <div class="cmbsqf-settings-layout">
            
            <!-- Sidebar Navigation -->
            <nav class="cmbsqf-sidebar-nav">
                <ul class="cmbsqf-sidebar-menu">
                    <?php 
                    $first = true;
                    foreach ($sections as $id => $section): 
                        $active_class = $first ? ' active' : '';
                        $first = false;
                    ?>
                        <li class="cmbsqf-sidebar-item<?php echo esc_attr($active_class); ?>">
                            <a href="#" class="cmbsqf-sidebar-link" data-section="<?php echo esc_attr($id); ?>">
                                <?php if (!empty($section['icon'])): ?>
                                    <span class="cmbsqf-sidebar-icon"><?php echo wp_kses_post($section['icon']); ?></span>
                                <?php endif; ?>
                                <span class="cmbsqf-sidebar-label"><?php echo esc_html($section['label']); ?></span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>

            <!-- Section Content -->
            <section class="cmbsqf-settings-content">
                <?php 
                $first = true;
                foreach ($sections as $id => $section): 
                    $display_style = $first ? 'block' : 'none';
                    $first = false;
                ?>
                    <div class="cmbsqf-section-content" data-section-id="<?php echo esc_attr($id); ?>" style="display: <?php echo esc_attr($display_style); ?>;">
                        <?php 
                        if (isset($section['callback']) && is_callable($section['callback'])) {
                            call_user_func($section['callback'], $form_id);
                        }
                        ?>
                    </div>
                <?php endforeach; ?>
            </section>

        </div>
        <?php
    }

    /**
     * Get SVG icon markup for sections.
     *
     * @param string $icon_name Icon identifier.
     * @return string SVG markup.
     */
    private static function get_icon($icon_name) {
        $icons = [
            'email'         => '<svg viewBox="0 0 24 24"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/><path d="M22 6l-10 7L2 6"/></svg>',
            'admin-network' => '<svg viewBox="0 0 24 24"><circle cx="12" cy="12" r="3"/><path d="M12 1v6m0 6v10M1 12h6m6 0h10"/><circle cx="12" cy="4" r="2"/><circle cx="12" cy="20" r="2"/><circle cx="20" cy="12" r="2"/><circle cx="4" cy="12" r="2"/></svg>',
            'groups'        => '<svg viewBox="0 0 24 24"><path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75"/></svg>',
            'megaphone'     => '<svg viewBox="0 0 24 24"><path d="M3 11l18-5v12L3 13v-2z"/><path d="M11.6 16.8a3 3 0 11-5.8-1.6"/></svg>',
        ];

        return $icons[$icon_name] ?? '';
    }
}
