<?php
/**
 * Form Tab Renderer
 *
 * Purpose: Renders the Form tab with 6 sections (Fields, UI Texts, Privacy, Styling, Bot Protection, Junk Email)
 * Used by: Settings pages (global and form contexts)
 * Location: /admin/tabs/class-tab-form.php
 *
 * This tab uses the Sidebar Renderer to render a sidebar navigation with 6 sections.
 * All configuration is visible in this file - no need to check other files.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load Sidebar Renderer


// Load section classes
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-fields.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-ui-texts.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-privacy.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-styling.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-bot-protection.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/sections/class-section-junk-email.php';

/**
 * Class CMBSQF_Tab_Form
 *
 * Renders Form tab with sidebar navigation for form-related settings.
 */
class CMBSQF_Tab_Form {

    /**
     * Render the Form tab.
     *
     * @param int $form_id Form ID (0 for global settings, specific ID for form settings).
     */
    public static function render($form_id = 0) {
        // Define sections for this tab
        $sections = [
            'fields' => [
                'label'    => __('Fields', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('fields'),
                'callback' => ['CMBSQF_Section_Fields', 'render'],
            ],
            'ui_texts' => [
                'label'    => __('UI Texts', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('messages'),
                'callback' => ['CMBSQF_Section_UI_Texts', 'render'],
            ],
            'privacy' => [
                'label'    => __('Privacy / GDPR', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('privacy'),
                'callback' => ['CMBSQF_Section_Privacy', 'render'],
            ],
            'styling' => [
                'label'    => __('Styling', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('styling'),
                'callback' => ['CMBSQF_Section_Styling', 'render'],
            ],
            'bot_protection' => [
                'label'    => __('Bot Protection', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('protection'),
                'callback' => ['CMBSQF_Section_Bot_Protection', 'render'],
            ],
            'junk_email' => [
                'label'    => __('Junk Email Protection', 'cmb-sqlite-form'),
                'icon'     => self::get_icon('trash'),
                'callback' => ['CMBSQF_Section_Junk_Email', 'render'],
            ],
        ];

        // Render Sidebar Layout (Inline)
        ?>
        <div class="cmbsqf-settings-layout">
            
            <!-- Sidebar Navigation -->
            <nav class="cmbsqf-sidebar-nav">
                <ul class="cmbsqf-sidebar-menu">
                    <?php 
                    $first = true;
                    foreach ($sections as $id => $section): 
                        $active_class = $first ? ' active' : '';
                        $first = false;
                    ?>
                        <li class="cmbsqf-sidebar-item<?php echo esc_attr($active_class); ?>">
                            <a href="#" class="cmbsqf-sidebar-link" data-section="<?php echo esc_attr($id); ?>">
                                <?php if (!empty($section['icon'])): ?>
                                    <span class="cmbsqf-sidebar-icon"><?php echo wp_kses_post($section['icon']); ?></span>
                                <?php endif; ?>
                                <span class="cmbsqf-sidebar-label"><?php echo esc_html($section['label']); ?></span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>

            <!-- Section Content -->
            <section class="cmbsqf-settings-content">
                <?php 
                $first = true;
                foreach ($sections as $id => $section): 
                    $display_style = $first ? 'block' : 'none';
                    $first = false;
                ?>
                    <div class="cmbsqf-section-content" data-section-id="<?php echo esc_attr($id); ?>" style="display: <?php echo esc_attr($display_style); ?>;">
                        <?php 
                        if (isset($section['callback']) && is_callable($section['callback'])) {
                            call_user_func($section['callback'], $form_id);
                        }
                        ?>
                    </div>
                <?php endforeach; ?>
            </section>

        </div>
        <?php
    }

    /**
     * Get SVG icon markup for sections.
     *
     * @param string $icon_name Icon identifier.
     * @return string SVG markup.
     */
    private static function get_icon($icon_name) {
        $icons = [
            'fields'     => '<svg viewBox="0 0 24 24"><rect x="3" y="3" width="18" height="18" rx="2"/><path d="M7 7h10M7 12h10M7 17h6"/></svg>',
            'messages'   => '<svg viewBox="0 0 24 24"><path d="M21 15a2 2 0 01-2 2H7l-4 4V5a2 2 0 012-2h14a2 2 0 012 2z"/></svg>',
            'privacy'    => '<svg viewBox="0 0 24 24"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>',
            'styling'    => '<svg viewBox="0 0 24 24"><path d="M12 2.69l5.66 5.66a8 8 0 11-11.31 0z"/></svg>',
            'protection' => '<svg viewBox="0 0 24 24"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/><path d="M9 12l2 2 4-4"/></svg>',
            'trash'      => '<svg viewBox="0 0 24 24"><path d="M3 6h18M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2M10 11v6M14 11v6"/></svg>',
        ];

        return $icons[$icon_name] ?? '';
    }
}
