<?php
/**
 * UI Texts Section Renderer
 *
 * Purpose: Renders the UI Texts section (Form tab)
 * Location: /admin/sections/class-section-ui-texts.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_UI_Texts
 *
 * Renders UI texts customization section.
 */
class CMBSQF_Section_UI_Texts {

    /**
     * Render the UI Texts section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load values from database (get() handles both global and form contexts)
        $header_html  = CMBSQF_DB_Settings::get('form__ui_texts__header_html', $form_id, '<h2>Contact Us</h2>');
        $success_text = CMBSQF_DB_Settings::get('form__ui_texts__success_text', $form_id, 'Thank you for your message. We will contact you soon.');
        $error_text   = CMBSQF_DB_Settings::get('form__ui_texts__error_text', $form_id, 'An error occurred. Please try again.');
        $submit_text  = CMBSQF_DB_Settings::get('form__ui_texts__submit_text', $form_id, 'Send Message');

        // Initialize override variable
        $override = '0';

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('form__ui_texts__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('ui_texts', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="ui-texts-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <label for="form__ui_texts__header_html">
                                <?php esc_html_e('Header HTML', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <textarea id="form__ui_texts__header_html"
                                      name="form__ui_texts__header_html"
                                      rows="5"
                                      class="large-text code"><?php echo esc_textarea($header_html); ?></textarea>
                            <p class="description">
                                <?php esc_html_e('HTML content displayed at the top of the form. Supports HTML tags like', 'cmb-sqlite-form'); ?>
                                <code>&lt;h2&gt;</code>, <code>&lt;p&gt;</code>, <code>&lt;strong&gt;</code>, <?php esc_html_e('etc. Leave empty to hide the header.', 'cmb-sqlite-form'); ?>
                            </p>

                            <details class="cmbsqf-examples-details">
                                <summary class="cmbsqf-examples-summary"><?php esc_html_e('Show examples', 'cmb-sqlite-form'); ?></summary>
                                <div class="cmbsqf-examples-content">
                                    <p><strong><?php esc_html_e('Example 1: Title + Subtitle', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('<h2>Contact Us</h2>
<p>We\'ll respond within 24 hours</p>'); ?></pre>

                                    <p><strong><?php esc_html_e('Example 2: With Description', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('<h2>Get in Touch</h2>
<p>Have a question? Fill out the form below.</p>
<p class="note">* Required fields</p>'); ?></pre>

                                    <p><strong><?php esc_html_e('Example 3: Simple Title', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('<h3>Contact Form</h3>'); ?></pre>
                                </div>
                            </details>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="form__ui_texts__success_text">
                                <?php esc_html_e('Success Message', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__ui_texts__success_text"
                                   name="form__ui_texts__success_text"
                                   value="<?php echo esc_attr($success_text); ?>"
                                   class="large-text" />
                            <p class="description">
                                <?php esc_html_e('Message shown after successful form submission.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="form__ui_texts__error_text">
                                <?php esc_html_e('Error Message', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__ui_texts__error_text"
                                   name="form__ui_texts__error_text"
                                   value="<?php echo esc_attr($error_text); ?>"
                                   class="large-text" />
                            <p class="description">
                                <?php esc_html_e('Message shown when form submission fails.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="form__ui_texts__submit_text">
                                <?php esc_html_e('Submit Button Text', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__ui_texts__submit_text"
                                   name="form__ui_texts__submit_text"
                                   value="<?php echo esc_attr($submit_text); ?>"
                                   class="regular-text" />
                            <p class="description">
                                <?php esc_html_e('Text displayed on the form submit button.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save UI Texts Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
