<?php
/**
 * To User Section Renderer
 *
 * Purpose: Renders the To User section (Notifications tab)
 * Location: /admin/sections/class-section-to-user.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_To_User
 *
 * Renders user confirmation email section.
 */
class CMBSQF_Section_To_User {

    /**
     * Render the To User section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load values from database
        $enabled = CMBSQF_DB_Settings::get('notifications__to_user__enabled', $form_id, '1');
        $subject = CMBSQF_DB_Settings::get('notifications__to_user__subject', $form_id, 'Thank you for contacting {site_name}');
        $message = CMBSQF_DB_Settings::get('notifications__to_user__message', $form_id, 
            "Hello {name},\n\n" .
            "Thank you for contacting {site_name}. We have received your message regarding \"{subject}\" and will get back to you shortly.\n\n" .
            "Best regards,\n" .
            "{site_name} Team"
        );

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('notifications__to_user__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('notifications__to_user', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="notifications--to-user-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <?php esc_html_e('Send Confirmation Email', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="notifications__to_user__enabled">
                                    <input type="checkbox"
                                           id="notifications__to_user__enabled"
                                           name="notifications__to_user__enabled"
                                           value="1"
                                           data-toggle-group="user-email-fields"
                                           <?php checked($enabled, '1'); ?> />
                                    <?php esc_html_e('Send confirmation email to users after form submission', 'cmb-sqlite-form'); ?>
                                </label>
                                <p class="description">
                                    <?php esc_html_e('When enabled, users will receive an automatic confirmation email at the address they provided.', 'cmb-sqlite-form'); ?>
                                </p>
                            </fieldset>
                        </td>
                    </tr>
                    <tr data-toggle-target="user-email-fields">
                        <th scope="row">
                            <label for="notifications__to_user__subject">
                                <?php esc_html_e('Email Subject', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="notifications__to_user__subject"
                                   name="notifications__to_user__subject"
                                   value="<?php echo esc_attr($subject); ?>"
                                   class="large-text" />
                            <p class="description">
                                <?php esc_html_e('Subject line for the confirmation email.', 'cmb-sqlite-form'); ?>
                                <br>
                                <?php echo wp_kses_post(__('Available variables: <code>{name}</code>, <code>{surname}</code>, <code>{email}</code>, <code>{subject}</code>, <code>{form_name}</code>, <code>{site_name}</code>, <code>{site_url}</code>, <code>{submission_id}</code>, <code>{date}</code>, <code>{ip_address}</code>', 'cmb-sqlite-form')); ?>
                            </p>
                        </td>
                    </tr>
                    <tr data-toggle-target="user-email-fields">
                        <th scope="row">
                            <label for="notifications__to_user__message">
                                <?php esc_html_e('Email Message', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <textarea id="notifications__to_user__message"
                                      name="notifications__to_user__message"
                                      rows="10"
                                      class="large-text code"><?php echo esc_textarea($message); ?></textarea>
                            <p class="description">
                                <?php esc_html_e('Body content of the confirmation email.', 'cmb-sqlite-form'); ?>
                                <br><br>
                                <?php echo wp_kses_post(__('Available variables: <code>{name}</code>, <code>{surname}</code>, <code>{email}</code>, <code>{phone}</code>, <code>{organization}</code>, <code>{website}</code>, <code>{position}</code>, <code>{subject}</code>, <code>{message}</code>, <code>{form_name}</code>, <code>{site_name}</code>, <code>{site_url}</code>, <code>{submission_id}</code>, <code>{date}</code>, <code>{ip_address}</code>', 'cmb-sqlite-form')); ?>
                            </p>

                            <details class="cmbsqf-examples-details">
                                <summary class="cmbsqf-examples-summary"><?php esc_html_e('Show examples', 'cmb-sqlite-form'); ?></summary>
                                <div class="cmbsqf-examples-content">
                                    <p><strong><?php esc_html_e('Example 1: Simple Confirmation', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('Hello {name},

Thank you for contacting {site_name}. We have received your message regarding "{subject}" and will get back to you shortly.

Best regards,
{site_name} Team'); ?></pre>

                                    <p><strong><?php esc_html_e('Example 2: HTML Formatted', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('<p>Hi <strong>{name}</strong>,</p>
<p>Thanks for reaching out! We received your inquiry about <em>{subject}</em>.</p>
<p>We will review your message and respond to <strong>{email}</strong> as soon as possible.</p>
<hr>
<p><small>Sent from <a href="{site_url}">{site_name}</a></small></p>'); ?></pre>
                                </div>
                            </details>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save To User Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
