<?php
/**
 * To Admin Section Renderer
 *
 * Purpose: Renders the To Admin section (Notifications tab)
 * Location: /admin/sections/class-section-to-admin.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_To_Admin
 *
 * Renders admin notification email section.
 */
class CMBSQF_Section_To_Admin {

    /**
     * Render the To Admin section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load values from database
        $enabled = CMBSQF_DB_Settings::get('notifications__to_admin__enabled', $form_id, '1');
        $emails  = CMBSQF_DB_Settings::get('notifications__to_admin__emails', $form_id, get_option('admin_email'));
        $subject = CMBSQF_DB_Settings::get('notifications__to_admin__subject', $form_id, 'New form submission from {name}');
        $message = CMBSQF_DB_Settings::get('notifications__to_admin__message', $form_id, "New submission on {form_name}:\n\n<strong>Name:</strong> {name} {surname}\n<strong>Email:</strong> {email}\n<strong>Phone:</strong> {phone}\n\n<strong>Message:</strong>\n{message}\n\n---\nSent from {site_name}");

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('notifications__to_admin__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('notifications__to_admin', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="notifications--to-admin-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <?php esc_html_e('Send Notification Email', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="notifications__to_admin__enabled">
                                    <input type="checkbox"
                                           id="notifications__to_admin__enabled"
                                           name="notifications__to_admin__enabled"
                                           value="1"
                                           data-toggle-group="admin-email-fields"
                                           <?php checked($enabled, '1'); ?> />
                                    <?php esc_html_e('Send notification email to administrators when form is submitted', 'cmb-sqlite-form'); ?>
                                </label>
                                <p class="description">
                                    <?php esc_html_e('When enabled, administrators will receive a notification email for each form submission.', 'cmb-sqlite-form'); ?>
                                </p>
                            </fieldset>
                        </td>
                    </tr>
                    <tr data-toggle-target="admin-email-fields">
                        <th scope="row">
                            <label for="notifications__to_admin__emails">
                                <?php esc_html_e('Recipient Email Addresses', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="notifications__to_admin__emails"
                                   name="notifications__to_admin__emails"
                                   value="<?php echo esc_attr($emails); ?>"
                                   class="large-text" />
                            <p class="description">
                                <?php esc_html_e('Email addresses that will receive form submission notifications. Separate multiple addresses with commas.', 'cmb-sqlite-form'); ?>
                                <br>
                                <?php esc_html_e('Example: admin@example.com, sales@example.com', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr data-toggle-target="admin-email-fields">
                        <th scope="row">
                            <label for="notifications__to_admin__subject">
                                <?php esc_html_e('Email Subject', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="notifications__to_admin__subject"
                                   name="notifications__to_admin__subject"
                                   value="<?php echo esc_attr($subject); ?>"
                                   class="large-text" />
                            <p class="description">
                                <?php esc_html_e('Subject line for the notification email.', 'cmb-sqlite-form'); ?>
                                <br>
                                <?php echo wp_kses_post(__('Available variables: <code>{name}</code>, <code>{surname}</code>, <code>{email}</code>, <code>{subject}</code>, <code>{form_name}</code>, <code>{site_name}</code>, <code>{site_url}</code>, <code>{submission_id}</code>, <code>{date}</code>, <code>{ip_address}</code>, <code>{admin_link}</code>', 'cmb-sqlite-form')); ?>
                            </p>
                        </td>
                    </tr>
                    <tr data-toggle-target="admin-email-fields">
                        <th scope="row">
                            <label for="notifications__to_admin__message">
                                <?php esc_html_e('Email Message', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <textarea id="notifications__to_admin__message"
                                      name="notifications__to_admin__message"
                                      rows="10"
                                      class="large-text code"><?php echo esc_textarea($message); ?></textarea>
                            <p class="description">
                                <?php esc_html_e('Body content of the notification email.', 'cmb-sqlite-form'); ?>
                                <br>
                                <strong><?php esc_html_e('Supports HTML & Newlines!', 'cmb-sqlite-form'); ?></strong> <?php esc_html_e('Newlines are automatically converted to &lt;br&gt;. You can also use HTML tags.', 'cmb-sqlite-form'); ?>
                                <br><br>
                                <?php echo wp_kses_post(__('Available variables: <code>{name}</code>, <code>{surname}</code>, <code>{email}</code>, <code>{phone}</code>, <code>{organization}</code>, <code>{website}</code>, <code>{position}</code>, <code>{subject}</code>, <code>{message}</code>, <code>{form_name}</code>, <code>{site_name}</code>, <code>{site_url}</code>, <code>{submission_id}</code>, <code>{date}</code>, <code>{ip_address}</code>, <code>{admin_link}</code>', 'cmb-sqlite-form')); ?>
                            </p>

                            <details class="cmbsqf-examples-details">
                                <summary class="cmbsqf-examples-summary"><?php esc_html_e('Show examples', 'cmb-sqlite-form'); ?></summary>
                                <div class="cmbsqf-examples-content">
                                    <p><strong><?php esc_html_e('Example 1: Standard Notification', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('New submission on {form_name}:

Name: {name} {surname}
Email: {email}
Phone: {phone}

Message:
{message}

---
Sent from {site_name}'); ?></pre>

                                    <p><strong><?php esc_html_e('Example 2: HTML Table', 'cmb-sqlite-form'); ?></strong></p>
                                    <pre class="cmbsqf-code-example"><?php echo esc_html('<h3>New Submission: {subject}</h3>
<table border="1" cellpadding="5">
  <tr><td><strong>Name</strong></td><td>{name} {surname}</td></tr>
  <tr><td><strong>Email</strong></td><td>{email}</td></tr>
  <tr><td><strong>Message</strong></td><td>{message}</td></tr>
</table>
<p><a href="{admin_link}">View in Admin Panel</a></p>'); ?></pre>
                                </div>
                            </details>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save To Admin Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
