<?php
/**
 * Privacy / GDPR Section Renderer
 *
 * Purpose: Renders the Privacy / GDPR section (Form tab)
 * Location: /admin/sections/class-section-privacy.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_Privacy
 *
 * Renders privacy and GDPR compliance section.
 */
class CMBSQF_Section_Privacy {

    /**
     * Render the Privacy / GDPR section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load values from database
        $enabled  = CMBSQF_DB_Settings::get('form__privacy__enabled', $form_id, '0');
        $html     = CMBSQF_DB_Settings::get('form__privacy__html', $form_id, 'I accept the <a href="https://example.com/privacy">Privacy Policy</a>');

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('form__privacy__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('privacy', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="privacy-fields"' : ''; ?>>
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <?php esc_html_e('Privacy Checkbox', 'cmb-sqlite-form'); ?>
                            </th>
                            <td>
                                <fieldset>
                                    <label for="form__privacy__enabled">
                                        <input type="checkbox"
                                               id="form__privacy__enabled"
                                               name="form__privacy__enabled"
                                               value="1"
                                               data-toggle-group="privacy-enabled-fields"
                                               <?php checked($enabled, '1'); ?> />
                                        <?php esc_html_e('Show privacy policy acceptance checkbox', 'cmb-sqlite-form'); ?>
                                    </label>
                                    <p class="description">
                                        <?php esc_html_e('When enabled, users must check the privacy policy checkbox before submitting the form.', 'cmb-sqlite-form'); ?>
                                    </p>
                                </fieldset>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <div data-toggle-target="privacy-enabled-fields">
                    <table class="form-table" role="presentation">
                        <tbody>
                            <tr>
                                <th scope="row">
                                    <label for="form__privacy__html">
                                        <?php esc_html_e('Checkbox Label (HTML)', 'cmb-sqlite-form'); ?>
                                    </label>
                                </th>
                                <td>
                                    <textarea id="form__privacy__html"
                                              name="form__privacy__html"
                                              rows="3"
                                              class="large-text code"><?php echo esc_textarea($html); ?></textarea>
                                    <p class="description">
                                        <?php esc_html_e('HTML content for the privacy checkbox label. You can include a link to your privacy policy page.', 'cmb-sqlite-form'); ?>
                                        <br>
                                        <?php esc_html_e('Example: "I accept the &lt;a href="..."&gt;Privacy Policy&lt;/a&gt;"', 'cmb-sqlite-form'); ?>
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save Privacy Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
