<?php
/**
 * Information Section Renderer
 *
 * Purpose: Renders the Information section (General tab)
 * Location: /admin/sections/class-section-info.php
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class CMBSQF_Section_Info
 *
 * Renders plugin information section.
 */
class CMBSQF_Section_Info {

    /**
     * Render the Information section.
     *
     * @param int $form_id Form ID (always 0 for global-only section).
     */
    public static function render($form_id = 0) {
        // Get plugin version from main file
        $plugin_version = '2.0.0'; // Hardcoded for now

        // Get total forms count - hardcoded for now, will be loaded from DB later
        $total_forms = 0;

        // Get storage path
        $upload_dir = wp_upload_dir();
        $storage_path = trailingslashit($upload_dir['basedir']) . 'cmb-sqlite-form';

        ?>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('Plugin Information', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <p>
                            <strong><?php esc_html_e('Version:', 'cmb-sqlite-form'); ?></strong>
                            <?php echo esc_html($plugin_version); ?>
                            <br>
                            <strong><?php esc_html_e('Total Forms:', 'cmb-sqlite-form'); ?></strong>
                            <?php echo esc_html($total_forms); ?>
                            <br>
                            <strong><?php esc_html_e('Storage Location:', 'cmb-sqlite-form'); ?></strong>
                            <code><?php echo esc_html($storage_path); ?></code>
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>

        <hr class="cmbsqf-section-divider">

        <h2><?php esc_html_e('System Information', 'cmb-sqlite-form'); ?></h2>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('PHP Version:', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <?php echo esc_html(phpversion()); ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('WordPress Version:', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <?php echo esc_html(get_bloginfo('version')); ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('SQLite Extension:', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <?php if (class_exists('SQLite3')): ?>
                            <span class="cmbsqf-status-enabled">
                                ✓ <?php esc_html_e('Enabled', 'cmb-sqlite-form'); ?>
                            </span>
                            (<?php echo esc_html(SQLite3::version()['versionString']); ?>)
                        <?php else: ?>
                            <span class="cmbsqf-status-disabled">
                                ✗ <?php esc_html_e('Not Available', 'cmb-sqlite-form'); ?>
                            </span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('Max Upload Size:', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <?php echo esc_html(size_format(wp_max_upload_size())); ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <?php esc_html_e('Memory Limit:', 'cmb-sqlite-form'); ?>
                    </th>
                    <td>
                        <?php echo esc_html(ini_get('memory_limit')); ?>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php
    }
}
