<?php
/**
 * Fields Section Renderer
 *
 * Purpose: Renders the Fields section (Form tab)
 * Location: /admin/sections/class-section-fields.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_Fields
 *
 * Renders form field configuration section.
 */
class CMBSQF_Section_Fields {

    /**
     * Render the Fields section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Define available fields with their defaults and icons
        $fields = [
            'name' => [
                'label'    => __('Name', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__name_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__name_required', $form_id, '1'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M20 21v-2a4 4 0 00-4-4H8a4 4 0 00-4 4v2M12 11a4 4 0 100-8 4 4 0 000 8z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'surname' => [
                'label'    => __('Surname', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__surname_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__surname_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2M9 11a4 4 0 100-8 4 4 0 000 8zM23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'email' => [
                'label'    => __('Email', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__email_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__email_required', $form_id, '1'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/><path d="M22 6l-10 7L2 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'phone' => [
                'label'    => __('Phone', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__phone_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__phone_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M22 16.92v3a2 2 0 01-2.18 2 19.79 19.79 0 01-8.63-3.07 19.5 19.5 0 01-6-6 19.79 19.79 0 01-3.07-8.67A2 2 0 014.11 2h3a2 2 0 012 1.72 12.84 12.84 0 00.7 2.81 2 2 0 01-.45 2.11L8.09 9.91a16 16 0 006 6l1.27-1.27a2 2 0 012.11-.45 12.84 12.84 0 002.81.7A2 2 0 0122 16.92z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'organization' => [
                'label'    => __('Organization', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__organization_enabled', $form_id, '0'),
                'required' => CMBSQF_DB_Settings::get('form__fields__organization_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M3 9l9-7 9 7v11a2 2 0 01-2 2H5a2 2 0 01-2-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/><path d="M9 22V12h6v10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'position' => [
                'label'    => __('Position', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__position_enabled', $form_id, '0'),
                'required' => CMBSQF_DB_Settings::get('form__fields__position_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><rect x="2" y="7" width="20" height="14" rx="2" ry="2" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/><path d="M16 21V5a2 2 0 00-2-2h-4a2 2 0 00-2 2v16" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'website' => [
                'label'    => __('Website', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__website_enabled', $form_id, '0'),
                'required' => CMBSQF_DB_Settings::get('form__fields__website_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/><path d="M2 12h20M12 2a15.3 15.3 0 014 10 15.3 15.3 0 01-4 10 15.3 15.3 0 01-4-10 15.3 15.3 0 014-10z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'subject' => [
                'label'    => __('Subject', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__subject_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__subject_required', $form_id, '0'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M14 2H6a2 2 0 00-2 2v16a2 2 0 002 2h12a2 2 0 002-2V8z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/><path d="M14 2v6h6M16 13H8M16 17H8M10 9H8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
            'message' => [
                'label'    => __('Message', 'cmb-sqlite-form'),
                'enabled'  => CMBSQF_DB_Settings::get('form__fields__message_enabled', $form_id, '1'),
                'required' => CMBSQF_DB_Settings::get('form__fields__message_required', $form_id, '1'),
                'icon'     => '<svg viewBox="0 0 24 24" width="18" height="18"><path d="M21 15a2 2 0 01-2 2H7l-4 4V5a2 2 0 012-2h14a2 2 0 012 2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',
            ],
        ];

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('form__fields__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('fields', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="fields-fields"' : ''; ?>>
            <p class="description">
                <?php esc_html_e('Configure which fields are available in your forms and whether they are required.', 'cmb-sqlite-form'); ?>
            </p>

            <table class="cmb-sf-fields-table cmbsqf-fields-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Field', 'cmb-sqlite-form'); ?></th>
                        <th><?php esc_html_e('Enabled', 'cmb-sqlite-form'); ?></th>
                        <th><?php esc_html_e('Required', 'cmb-sqlite-form'); ?></th>
                        <th><?php esc_html_e('Custom Label', 'cmb-sqlite-form'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($fields as $field_id => $field_config) : ?>
                        <tr class="cmb-sf-field-row">
                            <td class="cmb-sf-field-name">
                                <span>
                                    <span class="cmb-sf-field-icon"><?php echo wp_kses_post($field_config['icon']); ?></span>
                                    <strong><?php echo esc_html(ucfirst($field_id)); ?></strong>
                                </span>
                            </td>
                            <td class="cmb-sf-field-toggle">
                                <label class="cmb-sf-toggle">
                                    <input type="checkbox"
                                           name="form__fields__<?php echo esc_attr($field_id); ?>_enabled"
                                           value="1"
                                           <?php checked($field_config['enabled'], '1'); ?> />
                                    <span class="cmb-sf-toggle-slider"></span>
                                </label>
                            </td>
                            <td class="cmb-sf-field-toggle">
                                <label class="cmb-sf-toggle">
                                    <input type="checkbox"
                                           name="form__fields__<?php echo esc_attr($field_id); ?>_required"
                                           value="1"
                                           <?php checked($field_config['required'], '1'); ?> />
                                    <span class="cmb-sf-toggle-slider"></span>
                                </label>
                            </td>
                            <td class="cmb-sf-field-label">
                                <input type="text"
                                       name="form__fields__<?php echo esc_attr($field_id); ?>_label"
                                       value="<?php echo esc_attr($field_config['label']); ?>"
                                       class="regular-text"
                                       placeholder="<?php echo esc_attr($field_config['label']); ?>" />
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <p class="description cmbsqf-fields-note">
                <strong><?php esc_html_e('Note:', 'cmb-sqlite-form'); ?></strong>
                <?php esc_html_e('Enabled fields will appear in the form. Required fields must be filled out by users before submission.', 'cmb-sqlite-form'); ?>
            </p>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save Field Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
