<?php
/**
 * Data Management Section Renderer
 *
 * Purpose: Renders the Data Management section (General tab)
 * Location: /admin/sections/class-section-data.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_Data
 *
 * Renders Data Management settings section.
 */
class CMBSQF_Section_Data {

    /**
     * Render the Data Management section.
     *
     * @param int $form_id Form ID (always 0 for global-only section).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load value from database
        $delete_on_uninstall = CMBSQF_DB_Settings::get('general__data__delete_on_uninstall', $form_id, '0');

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('general__data__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('data', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="data-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <?php esc_html_e('Delete on Uninstall', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="general__data__delete_on_uninstall">
                                    <input type="checkbox"
                                           id="general__data__delete_on_uninstall"
                                           name="general__data__delete_on_uninstall"
                                           value="1"
                                           <?php checked($delete_on_uninstall, '1'); ?> />
                                    <?php esc_html_e('Delete all plugin data when uninstalling', 'cmb-sqlite-form'); ?>
                                </label>
                                <p class="description">
                                    <?php esc_html_e('When enabled, all forms, entries, and settings will be permanently deleted when you uninstall this plugin.', 'cmb-sqlite-form'); ?>
                                    <br>
                                    <strong class="cmbsqf-warning-text">
                                        <?php esc_html_e('Warning: This action cannot be undone!', 'cmb-sqlite-form'); ?>
                                    </strong>
                                </p>
                            </fieldset>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save Data Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
