<?php
/**
 * Bot Protection Section Renderer
 *
 * Purpose: Renders the Bot Protection section (General tab)
 * Location: /admin/sections/class-section-bot-protection.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_Bot_Protection
 *
 * Renders bot protection and anti-spam section.
 */
class CMBSQF_Section_Bot_Protection {

    /**
     * Render the Bot Protection section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load values from database
        $honeypot         = CMBSQF_DB_Settings::get('form__bot_protection__honeypot', $form_id, '1');
        $honeypot_field   = CMBSQF_DB_Settings::get('form__bot_protection__honeypot_field', $form_id, 'business_url');
        $min_time_enabled = CMBSQF_DB_Settings::get('form__bot_protection__min_time_enabled', $form_id, '1');
        $min_time         = CMBSQF_DB_Settings::get('form__bot_protection__min_time', $form_id, '3');
        $captcha_enabled  = CMBSQF_DB_Settings::get('form__bot_protection__captcha_enabled', $form_id, '0');
        $captcha_question = CMBSQF_DB_Settings::get('form__bot_protection__captcha_question', $form_id, '');
        $captcha_answer   = CMBSQF_DB_Settings::get('form__bot_protection__captcha_answer', $form_id, '');

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('form__bot_protection__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('bot-protection', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="bot-protection-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <?php esc_html_e('Enable Honeypot', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="form__bot_protection__honeypot">
                                    <input type="checkbox"
                                           id="form__bot_protection__honeypot"
                                           name="form__bot_protection__honeypot"
                                           value="1"
                                           data-toggle-group="honeypot-fields"
                                           <?php checked($honeypot, '1'); ?> />
                                    <?php esc_html_e('Enable honeypot field for spam prevention', 'cmb-sqlite-form'); ?>
                                </label>
                            </fieldset>
                        </td>
                    </tr>
                    <tr data-toggle-target="honeypot-fields">
                        <th scope="row">
                            <label for="form__bot_protection__honeypot_field">
                                <?php esc_html_e('Honeypot Field Name', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__bot_protection__honeypot_field"
                                   name="form__bot_protection__honeypot_field"
                                   value="<?php echo esc_attr($honeypot_field); ?>"
                                   class="regular-text"
                                   pattern="[a-z_]+"
                                   placeholder="business_url" />
                            <p class="description">
                                <?php esc_html_e('Name of the hidden honeypot field. Use only lowercase letters and underscores.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr class="cmbsqf-settings-spacer">
                        <th scope="row">
                            <?php esc_html_e('Enable Time Validation', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="form__bot_protection__min_time_enabled">
                                    <input type="checkbox"
                                           id="form__bot_protection__min_time_enabled"
                                           name="form__bot_protection__min_time_enabled"
                                           value="1"
                                           data-toggle-group="time-validation-fields"
                                           <?php checked($min_time_enabled, '1'); ?> />
                                    <?php esc_html_e('Require minimum time to fill form', 'cmb-sqlite-form'); ?>
                                </label>
                            </fieldset>
                        </td>
                    </tr>
                    <tr data-toggle-target="time-validation-fields">
                        <th scope="row">
                            <label for="form__bot_protection__min_time">
                                <?php esc_html_e('Minimum Time (seconds)', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="number"
                                   id="form__bot_protection__min_time"
                                   name="form__bot_protection__min_time"
                                   value="<?php echo esc_attr($min_time); ?>"
                                   class="small-text"
                                   min="1"
                                   max="60" />
                            <p class="description">
                                <?php esc_html_e('Minimum seconds required before form can be submitted (1-60 seconds).', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr class="cmbsqf-settings-spacer">
                        <th scope="row">
                            <?php esc_html_e('Enable CAPTCHA', 'cmb-sqlite-form'); ?>
                        </th>
                        <td>
                            <fieldset>
                                <label for="form__bot_protection__captcha_enabled">
                                    <input type="checkbox"
                                           id="form__bot_protection__captcha_enabled"
                                           name="form__bot_protection__captcha_enabled"
                                           value="1"
                                           data-toggle-group="captcha-fields"
                                           <?php checked($captcha_enabled, '1'); ?> />
                                    <?php esc_html_e('Enable simple question CAPTCHA', 'cmb-sqlite-form'); ?>
                                </label>
                            </fieldset>
                        </td>
                    </tr>
                    <tr data-toggle-target="captcha-fields">
                        <th scope="row">
                            <label for="form__bot_protection__captcha_question">
                                <?php esc_html_e('CAPTCHA Question', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__bot_protection__captcha_question"
                                   name="form__bot_protection__captcha_question"
                                   value="<?php echo esc_attr($captcha_question); ?>"
                                   class="large-text"
                                   placeholder="What is 2 + 2?" />
                            <p class="description">
                                <?php esc_html_e('Question to ask users for verification. Keep it simple and clear.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr data-toggle-target="captcha-fields">
                        <th scope="row">
                            <label for="form__bot_protection__captcha_answer">
                                <?php esc_html_e('CAPTCHA Answer', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__bot_protection__captcha_answer"
                                   name="form__bot_protection__captcha_answer"
                                   value="<?php echo esc_attr($captcha_answer); ?>"
                                   class="regular-text"
                                   placeholder="4" />
                            <p class="description">
                                <?php esc_html_e('Correct answer to the CAPTCHA question. Answer matching is case-insensitive.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save Bot Protection Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
