<?php
/**
 * Behavior Section Renderer
 *
 * Purpose: Renders the Behavior section (Form tab)
 * Location: /admin/sections/class-section-behavior.php
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/helpers/class-helper-override-box.php';
require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';

/**
 * Class CMBSQF_Section_Behavior
 *
 * Renders Behavior settings section.
 */
class CMBSQF_Section_Behavior {

    /**
     * Render the Behavior section.
     *
     * @param int $form_id Form ID (0 for global, specific ID for form).
     */
    public static function render($form_id = 0) {
        $context = $form_id > 0 ? 'form' : 'global';

        // Load value from database
        $default_template = CMBSQF_DB_Settings::get('form__behavior__default_form_name_template', $form_id, 'Form {id}');

        ?>
        <form class="cmbsqf-settings-form" data-context="<?php echo esc_attr($context); ?>" <?php echo $form_id > 0 ? 'data-form-id="' . esc_attr($form_id) . '"' : ''; ?>>

            <?php
            // Render Override Box (only for form context)
            if ($form_id > 0) {
                $override = CMBSQF_DB_Settings::get('form__behavior__override', $form_id, '0');
                CMBSQF_Helper_Override_Box::render('behavior', $override, $form_id);
            }
            ?>

            <div <?php echo $form_id > 0 ? 'data-toggle-target="behavior-fields"' : ''; ?>>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row">
                            <label for="form__behavior__default_form_name_template">
                                <?php esc_html_e('Default Form Name Template', 'cmb-sqlite-form'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text"
                                   id="form__behavior__default_form_name_template"
                                   name="form__behavior__default_form_name_template"
                                   value="<?php echo esc_attr($default_template); ?>"
                                   class="regular-text" />
                            <p class="description">
                                <?php esc_html_e('Template for new form names. Use {id} as placeholder for form ID.', 'cmb-sqlite-form'); ?><br>
                                <?php esc_html_e('Example: "Form {id}" will create forms named "Form 1", "Form 2", etc.', 'cmb-sqlite-form'); ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Save Behavior Settings', 'cmb-sqlite-form'); ?>
                </button>
            </p>
        </form>
        <?php
    }
}
