<?php
/**
 * Global Settings Page Renderer
 *
 * Purpose: Renders the global plugin settings page with tabs and sections
 * Uses: CMBSQF_Renderer_Settings (composition pattern)
 * Called by: CMBSQF_Pages::render_global_settings()
 * Location: /admin/pages/class-page-global-settings.php
 *
 * This class is independent and self-contained. All configuration is visible
 * here - no inheritance magic. Uses composition via renderer helper.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/tabs/class-tab-general.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/tabs/class-tab-form.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/tabs/class-tab-notifications.php';

/**
 * Class CMBSQF_Page_Global_Settings
 *
 * Renders global settings page. All configuration is visible in this file.
 */
class CMBSQF_Page_Global_Settings {

    /**
     * Main entry point to render the global settings page.
     */
    public static function render() {
        // Render page header
        ?>
        <div class="wrap">
            <h1><?php esc_html_e('Global Settings', 'cmb-sqlite-form'); ?></h1>
            <p class="description">
                <?php esc_html_e('Configure global default settings for all forms. Each form can override these defaults in its Form Settings page.', 'cmb-sqlite-form'); ?>
            </p>

            <!-- Render all tabs (SPA style) -->
            <!-- Tab Navigation -->
            <nav class="nav-tab-wrapper cmbsqf-tabs-nav">
                <a href="#" class="nav-tab nav-tab-active" data-tab="general">
                    <?php esc_html_e('General', 'cmb-sqlite-form'); ?>
                </a>
                <a href="#" class="nav-tab" data-tab="form">
                    <?php esc_html_e('Form', 'cmb-sqlite-form'); ?>
                </a>
                <a href="#" class="nav-tab" data-tab="notifications">
                    <?php esc_html_e('Notifications', 'cmb-sqlite-form'); ?>
                </a>
            </nav>

            <!-- Tab Content: General -->
            <div class="cmbsqf-tab-content active" data-tab-id="general">
                <?php CMBSQF_Tab_General::render(0); ?>
            </div>

            <!-- Tab Content: Form -->
            <div class="cmbsqf-tab-content" data-tab-id="form">
                <?php CMBSQF_Tab_Form::render(0); ?>
            </div>

            <!-- Tab Content: Notifications -->
            <div class="cmbsqf-tab-content" data-tab-id="notifications">
                <?php CMBSQF_Tab_Notifications::render(0); ?>
            </div>
        </div>
        <?php
    }
}
