<?php
/**
 * Form Settings Page Renderer
 *
 * Purpose: Renders the per-form settings page with tabs and sections
 * Uses: CMBSQF_Renderer_Settings (composition pattern)
 * Called by: CMBSQF_Pages::render_view_all_forms()
 * Location: /admin/pages/class-page-form-settings.php
 *
 * This class is independent and self-contained. All configuration is visible
 * here - no inheritance magic. Uses composition via renderer helper.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load dependencies
require_once CMBSQF_PLUGIN_DIR . 'admin/tabs/class-tab-form.php';
require_once CMBSQF_PLUGIN_DIR . 'admin/tabs/class-tab-notifications.php';

/**
 * Class CMBSQF_Page_Form_Settings
 *
 * Renders form-specific settings page. All configuration is visible in this file.
 */
class CMBSQF_Page_Form_Settings {

    /**
     * Main entry point to render the form settings page.
     *
     * @param int $form_id Form ID.
     */
    public static function render($form_id) {
        // Validate form ID
        $form_id = max(1, (int) $form_id);

        // Get form name
        require_once CMBSQF_PLUGIN_DIR . 'includes/db/class-db-settings.php';
        $form_name = CMBSQF_DB_Settings::get('form_name', $form_id, sprintf('Form #%d', $form_id));

        // Render page header
        $base_url = admin_url('admin.php?page=' . CMBSQF_Constants::SLUG_FORMS);
        $entries_url = add_query_arg(['view' => 'entries', 'form_id' => $form_id], $base_url);
        $settings_url = add_query_arg(['view' => 'settings', 'form_id' => $form_id], $base_url);
        ?>
        <div class="wrap">
            <div class="cmbsqf-header-nav">
                <a href="<?php echo esc_url($base_url); ?>" class="button">
                    &larr; <?php esc_html_e('Back to All Forms', 'cmb-sqlite-form'); ?>
                </a>
                <span class="cmbsqf-header-toggle">
                    [ <a href="<?php echo esc_url($entries_url); ?>"><?php esc_html_e('Entries', 'cmb-sqlite-form'); ?></a>
                    <span style="margin: 0 4px;">|</span>
                    <strong><?php esc_html_e('Settings', 'cmb-sqlite-form'); ?></strong> ]
                </span>
            </div>

            <h1 class="cmbsqf-header-title">
                <?php esc_html_e('Form Settings', 'cmb-sqlite-form'); ?>
                <span class="cmbsqf-form-badge">
                    <?php echo esc_html($form_name); ?> #<?php echo (int) $form_id; ?>
                </span>
            </h1>
            <p class="description">
                <?php esc_html_e('Configure behavior, appearance, notifications, and protection settings for this specific form.', 'cmb-sqlite-form'); ?>
            </p>

            <!-- Render all tabs (SPA style) -->
            <!-- Tab Navigation -->
            <nav class="nav-tab-wrapper cmbsqf-tabs-nav">
                <a href="#" class="nav-tab nav-tab-active" data-tab="form">
                    <?php esc_html_e('Form', 'cmb-sqlite-form'); ?>
                </a>
                <a href="#" class="nav-tab" data-tab="notifications">
                    <?php esc_html_e('Notifications', 'cmb-sqlite-form'); ?>
                </a>
            </nav>

            <!-- Tab Content: Form -->
            <div class="cmbsqf-tab-content active" data-tab-id="form">
                <?php CMBSQF_Tab_Form::render($form_id); ?>
            </div>

            <!-- Tab Content: Notifications -->
            <div class="cmbsqf-tab-content" data-tab-id="notifications">
                <?php CMBSQF_Tab_Notifications::render($form_id); ?>
            </div>
        </div>
        <?php
    }
}
