<?php
/**
 * Override Box Helper
 *
 * Purpose: Renders the "Override Global Settings" checkbox box.
 * Location: /admin/helpers/class-helper-override-box.php
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class CMBSQF_Helper_Override_Box
 *
 * Renders the override switch box for form settings.
 */
class CMBSQF_Helper_Override_Box {

    /**
     * Render the override checkbox box.
     *
     * @param string $section_key Section identifier (e.g., 'ui_texts', 'styling').
     * @param string $override_value Current override value ('1' or '0').
     * @param int    $form_id Form ID (must be > 0 to render).
     */
    public static function render($section_key, $override_value, $form_id) {
        // Only render for form-specific contexts
        if ($form_id <= 0) {
            return;
        }

        // Determine the correct prefix based on section_key
        // Notifications sections use 'notifications__' prefix, others use 'form__'
        if (strpos($section_key, 'notifications__') === 0) {
            $field_name = "{$section_key}__override";
        } else {
            $field_name = "form__{$section_key}__override";
        }
        
        $toggle_group = str_replace('_', '-', $section_key) . '-fields';
        $section_label = ucwords(str_replace('_', ' ', $section_key));

        ?>
        <div class="cmbsqf-override-section">
            <label class="cmbsqf-override-label">
                <input type="checkbox"
                       name="<?php echo esc_attr($field_name); ?>"
                       value="1"
                       <?php checked($override_value, '1'); ?>
                       data-toggle-group="<?php echo esc_attr($toggle_group); ?>"
                       class="cmbsqf-override-checkbox" />
                <span class="cmbsqf-override-text">
                    <?php
                    /* translators: %s: section name */
                    printf(esc_html__('Override global %s for this form', 'cmb-sqlite-form'), esc_html($section_label));
                    ?>
                </span>
            </label>
            <p class="description cmbsqf-override-description">
                <?php esc_html_e('When enabled, this form will use its own custom settings instead of the global defaults.', 'cmb-sqlite-form'); ?>
            </p>
        </div>
        <?php
    }
}
