<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Menu Placeholder
 *
 * Registers placeholder menu items in WordPress admin.
 * Used in context: wp-admin (NOT in plugin pages)
 * Location: /admin/class-menu-placeholder.php
 */
class CMBSQF_Menu_Placeholder {
    /**
     * Register the admin menu structure.
     */
    public static function register() {
        add_action('admin_menu', [__CLASS__, 'register_menu_page']);
    }

    /**
     * Register the top-level admin page.
     */
    public static function register_menu_page() {
        add_menu_page(
            __('CMB SQLite Form', 'cmb-sqlite-form'),
            __('CMB SQLite Form', 'cmb-sqlite-form'),
            'manage_options',
            CMBSQF_Constants::SLUG_DASHBOARD,
            '__return_null',
            'dashicons-email'
        );

        add_submenu_page(
            CMBSQF_Constants::SLUG_DASHBOARD,
            __('View All Forms', 'cmb-sqlite-form'),
            __('View All Forms', 'cmb-sqlite-form'),
            'manage_options',
            CMBSQF_Constants::SLUG_FORMS,
            '__return_null'
        );

        add_submenu_page(
            CMBSQF_Constants::SLUG_DASHBOARD,
            __('Global Settings', 'cmb-sqlite-form'),
            __('Global Settings', 'cmb-sqlite-form'),
            'manage_options',
            CMBSQF_Constants::SLUG_SETTINGS,
            '__return_null'
        );

        // Remove the automatic duplicate submenu that mirrors the parent.
        remove_submenu_page(CMBSQF_Constants::SLUG_DASHBOARD, CMBSQF_Constants::SLUG_DASHBOARD);
    }
}
