/**
 * UI Component: Tab Navigation
 * Handles tab switching and sidebar navigation.
 */

/**
 * Setup simple tabs
 */
export default function initTabNavigation() {
    // Main Tabs Navigation
    setupTabs('.cmbsqf-tabs-nav a[data-tab]', '.cmbsqf-tab-content', 'nav-tab-active');

    // Sidebar Navigation
    setupSidebar();
}

function setupTabs(triggerSelector, contentSelector, activeClass) {
    const triggers = document.querySelectorAll(triggerSelector);

    triggers.forEach(trigger => {
        // Prevent focus on mousedown
        trigger.addEventListener('mousedown', function (e) {
            e.preventDefault();
        });

        trigger.addEventListener('click', function (e) {
            e.preventDefault();
            this.blur();

            const targetId = this.dataset.tab;

            // Update Triggers
            triggers.forEach(t => t.classList.remove(activeClass));
            this.classList.add(activeClass);

            // Update Content
            document.querySelectorAll(contentSelector).forEach(c => c.classList.remove('active'));
            const target = document.querySelector(`${contentSelector}[data-tab-id="${targetId}"]`);
            if (target) {
                target.classList.add('active');
            }
        });
    });
}

function setupSidebar() {
    document.addEventListener('click', function (e) {
        const link = e.target.closest('.cmbsqf-sidebar-link');
        if (link) {
            e.preventDefault();

            const container = link.closest('.cmbsqf-settings-layout');
            const targetId = link.dataset.section;

            // Update Sidebar Active State
            container.querySelectorAll('.cmbsqf-sidebar-item').forEach(item => item.classList.remove('active'));
            link.closest('.cmbsqf-sidebar-item').classList.add('active');

            // Update Content Visibility
            container.querySelectorAll('.cmbsqf-section-content').forEach(section => {
                section.style.display = 'none';
            });
            const targetSection = container.querySelector(`.cmbsqf-section-content[data-section-id="${targetId}"]`);
            if (targetSection) {
                targetSection.style.display = 'block';
                // Dispatch event for components that need to refresh (like CodeMirror)
                document.dispatchEvent(new CustomEvent('cmbsqf:section-shown', { detail: { sectionId: targetId } }));
            }
        }
    });

    // Prevent focus on mousedown (solves drag-focus issue)
    document.addEventListener('mousedown', function (e) {
        const link = e.target.closest('.cmbsqf-sidebar-link');
        if (link) {
            e.preventDefault();
        }
    });
}
