/**
 * Forms Utilities
 * Shared utility functions and constants for forms management
 */

// Animation timing constants
export const FADE_OUT_DURATION = 500;
export const TABLE_CHECK_DELAY = 600;

/**
 * Fetch wrapper with automatic nonce injection
 */
export async function fetchWithNonce(url, options = {}) {
    const defaultOptions = {
        headers: {
            'Content-Type': 'application/json',
            'X-WP-Nonce': window.cmbsqfSettings.nonce,
            ...(options.headers || {})
        }
    };

    return fetch(url, { ...options, ...defaultOptions });
}

/**
 * Get REST API base URL
 */
export function getRestUrl(endpoint = '') {
    return `${window.cmbsqfSettings.restUrl}${endpoint}`;
}
export async function handleCopyShortcode(trigger) {
    const shortcode = trigger.getAttribute('data-shortcode');

    if (!shortcode) {
        return;
    }

    try {
        await navigator.clipboard.writeText(shortcode);

        // Temporarily change icon to checkmark
        const icon = trigger.querySelector('svg');
        if (icon) {
            const originalIcon = icon.outerHTML;
            icon.outerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"></polyline></svg>';

            setTimeout(() => {
                const checkmark = trigger.querySelector('svg');
                if (checkmark) {
                    checkmark.outerHTML = originalIcon;
                }
            }, 1500);
        }
    } catch (err) {
        console.error('Failed to copy shortcode:', err);
        alert('Failed to copy shortcode');
    }
}
