/**
 * Forms Controller Module (Entry Point)
 * Coordinates all forms management functionality
 */

import { handleCreateForm, handleRenameForm, handleDeleteForm, handleBulkDelete } from './forms/forms-crud.js';
import { handleCopyShortcode } from './forms/forms-utils.js';

/**
 * Initialize forms manager
 */
function init() {
    bindEvents();
}

/**
 * Bind event listeners
 */
function bindEvents() {
    // Create Form
    const createBtn = document.querySelector('.cmbsqf-create-form');
    if (createBtn) {
        createBtn.addEventListener('click', handleCreateForm);
    }

    // Rename Form
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('cmbsqf-rename-form')) {
            e.preventDefault();
            handleRenameForm(e.target);
        }
    });

    // Delete Form
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('cmbsqf-delete-form')) {
            e.preventDefault();
            handleDeleteForm(e.target);
        }
    });

    // Copy Shortcode
    document.addEventListener('click', function (e) {
        const copyBtn = e.target.closest('.cmbsqf-copy-shortcode');
        if (copyBtn) {
            e.preventDefault();
            handleCopyShortcode(copyBtn);
        }
    });

    // Bulk Actions (Top)
    const doActionTop = document.getElementById('doaction');
    if (doActionTop) {
        doActionTop.addEventListener('click', function (e) {
            handleBulkAction(e, 'top');
        });
    }

    // Bulk Actions (Bottom)
    const doActionBottom = document.getElementById('doaction2');
    if (doActionBottom) {
        doActionBottom.addEventListener('click', function (e) {
            handleBulkAction(e, 'bottom');
        });
    }
}

/**
 * Handle bulk actions
 */
async function handleBulkAction(e, position) {
    const selectorId = position === 'top' ? 'bulk-action-selector-top' : 'bulk-action-selector-bottom';
    const selector = document.getElementById(selectorId);

    if (!selector || selector.value !== 'delete') {
        return; // Let default handler proceed
    }

    e.preventDefault();

    // Get selected IDs
    const checkboxes = document.querySelectorAll('input[name="form_ids[]"]:checked');
    if (checkboxes.length === 0) {
        return;
    }

    const ids = Array.from(checkboxes).map(cb => parseInt(cb.value));

    await handleBulkDelete(ids);
}

// Initialize when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
} else {
    init();
}
