<?php
/**
 * Azure Computer Vision API Provider
 * 
 * @package CM_Auto_Alt_Text
 * @version 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Azure Computer Vision API Provider
 */
class CM_Auto_Alt_Text_Azure_Vision_Provider extends CM_Auto_Alt_Text_Abstract_Provider {

    public function get_id() { return 'azure_vision'; }
    public function get_display_name() { return 'Azure Computer Vision'; }
    public function get_description() { return 'Microsoft Azure Computer Vision provides enterprise-grade image analysis with comprehensive features.'; }
    
    protected function get_default_config() {
        return [
            'enabled' => false,
            'api_key' => '',
            'endpoint' => '',
            'priority' => 4,
            'cost_per_call' => 0.001,
            'max_file_size' => 4 * 1024 * 1024,
            'timeout' => 30,
        ];
    }

    public function generate_alt_text($image_path, $options = []) {
        throw new Exception('Azure Vision provider coming soon in v1.4.1');
    }

    public function test_connection() {
        throw new Exception('Azure Vision provider coming soon in v1.4.1');
    }

    public function get_config_fields() {
        return [
            'api_key' => ['type' => 'text', 'label' => 'API Key', 'required' => true],
            'endpoint' => ['type' => 'text', 'label' => 'Endpoint URL', 'required' => true],
            'enabled' => ['type' => 'checkbox', 'label' => 'Enable Provider', 'default' => false],
            'priority' => ['type' => 'number', 'label' => 'Priority', 'default' => 4],
        ];
    }

    public function get_config_value($key, $default = null) {
        return isset($this->config[$key]) ? $this->config[$key] : $default;
    }

    public function get_limitations() {
        return ['status' => 'Coming soon in v1.4.1'];
    }

    public function get_pricing() {
        return ['status' => 'Coming soon in v1.4.1'];
    }

    public function supports_batch() { return false; }
    public function get_supported_types() { return []; }
}