<?php
/**
 * AWS Rekognition Provider
 * 
 * @package CM_Auto_Alt_Text
 * @version 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * AWS Rekognition Provider
 */
class CM_Auto_Alt_Text_AWS_Rekognition_Provider extends CM_Auto_Alt_Text_Abstract_Provider {

    public function get_id() { return 'aws_rekognition'; }
    public function get_display_name() { return 'AWS Rekognition'; }
    public function get_description() { return 'Amazon Web Services Rekognition for scalable image recognition and analysis.'; }
    
    protected function get_default_config() {
        return [
            'enabled' => false,
            'access_key' => '',
            'secret_key' => '',
            'region' => 'us-east-1',
            'priority' => 4,
            'cost_per_call' => 0.001,
            'max_file_size' => 5 * 1024 * 1024,
            'timeout' => 30,
        ];
    }

    public function generate_alt_text($image_path, $options = []) {
        throw new Exception('AWS Rekognition provider coming soon in v1.4.1');
    }

    public function test_connection() {
        throw new Exception('AWS Rekognition provider coming soon in v1.4.1');
    }

    public function get_config_fields() {
        return [
            'access_key' => ['type' => 'text', 'label' => 'Access Key ID', 'required' => true],
            'secret_key' => ['type' => 'password', 'label' => 'Secret Access Key', 'required' => true],
            'region' => ['type' => 'select', 'label' => 'Region', 'default' => 'us-east-1'],
            'enabled' => ['type' => 'checkbox', 'label' => 'Enable Provider', 'default' => false],
            'priority' => ['type' => 'number', 'label' => 'Priority', 'default' => 4],
        ];
    }

    public function get_config_value($key, $default = null) {
        return isset($this->config[$key]) ? $this->config[$key] : $default;
    }

    public function get_limitations() {
        return ['status' => 'Coming soon in v1.4.1'];
    }

    public function get_pricing() {
        return ['status' => 'Coming soon in v1.4.1'];
    }

    public function supports_batch() { return false; }
    public function get_supported_types() { return []; }
}