(function( $ ) {
	'use strict';

	$( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function( $scope ) {
        
	        /*==========================
			Data Aos
			==========================*/
		    AOS.init({
		        once: true,
		        disable: function() {
		            var maxWidth = 991;
		            return window.innerWidth < maxWidth;
		        }
		    });
		    
		    /*==========================
			Odometer
			==========================*/
		    $('.odometer').appear(function(e) {
				var odo = $(".odometer");
				odo.each(function() {
					var countNumber = $(this).attr("data-count");
					$(this).html(countNumber);
				});
			});

			/*==========================
			Slider Area Style One
			==========================*/
		    $('.slider-area.style-one .hero-slider-wrap').owlCarousel({
				loop: true,
				margin: 0,
				nav: true,
				mouseDrag: true,
				items: 1,
				dots: false,
				autoHeight: true,
				autoplay: true,
				smartSpeed: 800,
				autoplayHoverPause: true,
				navText: [
					"<i class='bx bx-chevrons-left'></i>",
					"<i class='bx bx-chevrons-right'></i>"
				]
			});

			/*==========================
			Slider Area Style Two
			==========================*/
		    $('.slider-area.style-two .home-slider').owlCarousel({
				loop: true,
				nav: true,
				dots: false,
				mouseDrag: true,
				autoplay: true,
				autoplayHoverPause: true,
				animateOut: 'fadeOut',
				animateIn: 'fadeIn',
				items: 1,
				navText: [
					"<i class='bx bx-left-arrow-alt'></i>",
					"<i class='bx bx-right-arrow-alt'></i>"
				]
			});

		    /*==========================
			Slider Area Style Three
			==========================*/
			$(".slider-area.style-three .banner-slider").owlCarousel({
		        items: 1,
		        loop: true,
		        nav: true,
		        navText: [
		            "<i class='bx bx-chevron-left'></i>", 
		            "<i class='bx bx-chevron-right'></i>"],
		        dots: false,
		        autoplay: true,
		        autoplayHoverPause: true,
		        smartSpeed: 500,
		        responsive: {
		            0: {
		                nav: false
		            },
		            768: {
		                nav: false
		            },
		            992: {
		                nav: true
		            },
		            1200: {
		                nav: true
		            }
		        },
		    });
		    
		    /*==========================
			Slider Area Style Four
			==========================*/
			$('.slider-area.style-four .banner-slider').owlCarousel({
				loop: true,
				margin: 0,
				nav: true,
				dots: false,
				autoplay: true,
				smartSpeed: 1000,
				autoplayHoverPause: true,
				navText: [
		            "<i class='flaticon-left-arrow' ></i>" ,
					"<i class='flaticon-right-arrow' ></i>" 
		        ],  
				responsivee:{
					0:{ 
						items:1
					},
					570:{
						items:1
					},
					768:{
						items:1
					},
					992:{
						items:1
					},
					1200:{
						items:1
					}
				}
			});

			/*==========================
			Slider Area Style Five
			==========================*/
			$('.slider-area.style-five .main-slider').owlCarousel({
				loop: true,
				nav: true,
				dots: false,
				mouseDrag: true,
				autoplay: true,
				autoplayHoverPause: true,
				smartSpeed: 1500,
				items: 1,
				navText: [
					"<i class='bx bx-left-arrow-alt'></i>",
					"<i class='bx bx-right-arrow-alt'></i>"
				]
			});
		    
		    /*==========================
			Slider Area Style Six
			==========================*/
			$('.slider-area.style-six .slider-carousel').owlCarousel({
		        loop: true,
				margin: 0,
				nav: true,
				animateOut: 'fadeOut',
				animateIn: 'fadeIn',
				active: true,
				smartSpeed: 1000,
				autoplay: true,
		        navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
		        responsive:{
		            0:{
		                items:1
		            },
		            600:{
		                items:1
		            },
		            800:{
		                items:1
		            },
		            1024:{
		                items:1
		            }
		        }
		    });

		    /*==========================
			Slider Area Style Seven
			==========================*/
		    $('.slider-area.style-seven .hero-slider-wrap').owlCarousel({
		    	loop: true,
				margin: 0,
				nav: false,
				mouseDrag: true,
				thumbs: true,
				thumbsPrerendered: true,
				items: 1,
				dots: false,
				autoHeight: true,
				autoplay: true,
				smartSpeed: 1500,
				autoplayHoverPause: true
		    });

			/*==========================
			Slider Area Style Eight
			==========================*/
			$('.slider-area.style-eight .main-slider').owlCarousel({
		        loop: true,
				nav: true,
				dots: false,
				mouseDrag: true,
				autoplay: true,
				autoplayHoverPause: true,
				smartSpeed: 1500,
				items: 1,
				navText: [
					"<i class='bx bx-left-arrow-alt'></i>",
					"<i class='bx bx-right-arrow-alt'></i>"
				]
		    });

			/*==========================
			Slider Area Style Nine
			==========================*/
			$('.slider-area.style-nine .banner-slider').owlCarousel({
				loop: true,
				margin: 0,
				nav: false,
				dots: true,
				autoplay: true,
				smartSpeed: 1000,
				autoplayHoverPause: true,
				responsivee:{
					0:{ 
						items:1
					},
					570:{
						items:1
					},
					768:{
						items:1
					},
					992:{
						items:1
					},
					1200:{
						items:1
					}
				}
		    });

			/*==========================
			Slider Area Style Ten
			==========================*/
			$('.slider-area.style-ten .home-banner-slider-area').owlCarousel({
				autoplayHoverPause: true,
		        autoplaySpeed: 2000,
		        autoplay: true,
		        loop: true,
		        dots: false,
		        margin: 0,
		        items: 1,
		        nav: true,
		        navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>']
		    });

			/*==========================
			Slider Area Style Eleven
			==========================*/
			$('.slider-area.style-eleven .hero-slider-one').owlCarousel({
				nav: true,
		        dots: false,
		        loop: true,
		        margin: 0,
		        items: 1,
		        navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
		        smartSpeed: 1300,
		        autoplay: true,
		        autoplayTimeout: 4000,
		        autoplayHoverPause: false,
		        autoHeight: true
		    });

			/*==========================
			Slider Area Style Twelve
			==========================*/
			$('.slider-area.style-twelve .hero-slider-one').owlCarousel({
				nav: true,
		        dots: false,
		        loop: true,
		        margin: 0,
		        items: 1,
		        navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
		        smartSpeed: 1300,
		        autoplay: true,
		        autoplayTimeout: 4000,
		        autoplayHoverPause: false,
		        autoHeight: true
		    });

		    /*==========================
			Slider Area Style Thirteen
			==========================*/
			$('.slider-area.style-thirteen .hero-slider-one').owlCarousel({
				nav: true,
		        dots: false,
		        items:1,
		        loop: true,
		        margin: 25,
		        thumbs: false,
		        navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
		        smartSpeed: 1300,
		        autoplay: true,
		        autoplayTimeout: 4000,
		        autoplayHoverPause: false,
		        responsiveClass: true,
		        autoHeight: true
		    });

		    /*==========================
			Slider Area Style Fourteen
			==========================*/
			$('.slider-area.style-fourteen .hero-slider-one').owlCarousel({
		        nav: true,
		        dots: false,
		        loop: true,
		        margin: 20,
		        items: 1,
		        navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
		        thumbs: false,
		        smartSpeed: 1300,
		        autoplay: true,
		        autoplayTimeout: 4000,
		        autoplayHoverPause: false,
		        responsiveClass: true,
		        autoHeight: true
		    });

		    /*==========================
			Slider Area Style Fifteen
			==========================*/
			$('.slider-area.style-fifteen .hero-slider-one').owlCarousel({
		        items: 1,
		        nav: false,
		        dots: true,
		        loop: true,
		        margin: 0,
		        animateOut: 'fadeOut',
		        smartSpeed: 1300,
		        autoplay: true,
		        autoplayTimeout: 7000,
		        autoplayHoverPause: false,
		        responsiveClass: true,
		        autoHeight: true,
		        responsive: {
		            0: {
		                items: 1,
		                autoHeight: true
		            },
		            768: {
		                items: 1
		            }
		        }
		    });

	    });
    });

    /*==========================
	Data Aos
	==========================*/
    AOS.init({
        once: true,
        disable: function() {
            var maxWidth = 991;
            return window.innerWidth < maxWidth;
        }
    });

})( jQuery );
