<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://mhrtheme.com
 * @since      1.0.0
 *
 * @package    Clump
 * @subpackage Clump/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Clump
 * @subpackage Clump/public
 * @author     MhrTheme <hello@mhrtheme.com>
 */
class Clump_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( 'clump-font-1', plugin_dir_url( __FILE__ ) . 'fonts/fonts-1.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-font-2', plugin_dir_url( __FILE__ ) . 'fonts/fonts-2.css', array(), $this->version, 'all' );
        
        wp_enqueue_style( 'clump-bootstrap', plugin_dir_url( __FILE__ ) . 'css/clump-bootstrap.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-animate', plugin_dir_url( __FILE__ ) . 'css/clump-animate.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-aos', plugin_dir_url( __FILE__ ) . 'css/clump-aos.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-font-awesome', plugin_dir_url( __FILE__ ) . 'css/clump-font-awesome.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-boxicons', plugin_dir_url( __FILE__ ) . 'css/clump-boxicons.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-remix', plugin_dir_url( __FILE__ ) . 'css/clump-remixicon.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-flaticon', plugin_dir_url( __FILE__ ) . 'fonts/flaticon_mycollection.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-modal', plugin_dir_url( __FILE__ ) . 'css/clump-modal.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-owl-carousel', plugin_dir_url( __FILE__ ) . 'css/clump-owl-carousel.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-owl-theme', plugin_dir_url( __FILE__ ) . 'css/clump-owl-theme.css', array(), $this->version, 'all' );

        wp_enqueue_style( 'clump-odometer', plugin_dir_url( __FILE__ ) . 'css/clump-odometer.css', array(), $this->version, 'all' );

		wp_enqueue_style( 'clump-public', plugin_dir_url( __FILE__ ) . 'css/clump-public.css', array(), $this->version, 'all' );

		wp_enqueue_style( 'clump-public-responsive', plugin_dir_url( __FILE__ ) . 'css/clump-public-responsive.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( 'clump-bootstrap', plugin_dir_url( __FILE__ ) . 'js/clump-bootstrap.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-modal', plugin_dir_url( __FILE__ ) . 'js/clump-modal.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-owl-carousel', plugin_dir_url( __FILE__ ) . 'js/clump-owl-carousel.js', array( 'jquery' ), $this->version, false );

		//wp_enqueue_script( 'clump-owl-carousel-two', plugin_dir_url( __FILE__ ) . 'js/clump-owl-carousel-two.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-carousel-thumbs', plugin_dir_url( __FILE__ ) . 'js/clump-carousel-thumbs.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-appear', plugin_dir_url( __FILE__ ) . 'js/clump-appear.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-odometer', plugin_dir_url( __FILE__ ) . 'js/clump-odometer.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-parallax', plugin_dir_url( __FILE__ ) . 'js/clump-parallax.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( 'clump-aos', plugin_dir_url( __FILE__ ) . 'js/clump-aos.js', array( 'jquery' ), $this->version, false );

	}

}
