<?php

 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Enqueue admin scripts and styles.
*/

if( ! function_exists( 'clump_admin_scripts' ) ) :
function clump_admin_scripts(){
    wp_enqueue_style( 'clump-admin', plugin_dir_url( __FILE__ ) . 'css/admin.css', array(), '1.0.0', 'all' );
    wp_enqueue_script( 'clump-jquery-cookie', plugin_dir_url( __FILE__ ) . 'js/jquery.cookie.js', array( 'jquery' ), '1.0.0', true );
    wp_enqueue_script( 'clump-admin', plugin_dir_url( __FILE__ ) . 'js/admin.js', array( 'jquery' ), '1.0.0', true );
}
endif; 
add_action( 'admin_enqueue_scripts', 'clump_admin_scripts' );

function clump_admin_notice_review() {
    global $pagenow;
    if ( $pagenow == 'index.php' ) { ?>
    <div class="notice clump-theme-notice notice-success second-notice is-dismissible">
        <p class="review"><?php echo esc_html( 'Pro Version Available! You will get extra features and designs by using premium version.', 'clump' ); ?>
        </p>
        <p>
            <a class="button button-primary" href="https://templatemonster.com/wordpress-plugins/544897.html" target="_blank"><?php echo esc_html( 'View Pro Plugin', 'clump' ); ?></a>
            <button class="button button-secondary" target="_blank"><?php echo esc_html( "Don't Show Again", 'clump' ); ?></button>
        </p>
    </div>
    <?php  }
} 

if (isset($_COOKIE['ClumpSecondNotice'])) {
}
else {
   add_action( 'admin_notices', 'clump_admin_notice_review' );
}
