<?php

/**
 *
 * @link              https://mhrtheme.com
 * @since             1.0.0
 * @package           Clump
 *
 * @wordpress-plugin
 * Plugin Name:       Clump
 * Plugin URI:        https://pages.mhrtheme.com/clump/
 * Description:       Clump is a modern and visually dynamic WordPress plugin designed for websites.
 * Version:           1.0.0
 * Author:            MhrTheme
 * Author URI:        https://mhrtheme.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       clump
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CLUMP_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-clump-activator.php
 */
function clump_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-clump-activator.php';
	Clump_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-clump-deactivator.php
 */
function clump_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-clump-deactivator.php';
	Clump_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'clump_activate' );
register_deactivation_hook( __FILE__, 'clump_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-clump.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function clump_run() {

	$plugin = new Clump();
	$plugin->run();

}
clump_run();
