<div class="cluevo-quiz-intro">
  <h1><?php esc_html_e("CLUEVO AI Quiz Maker", "cluevo"); ?></h1>
  <p><?php esc_html_e("Introducing our AI Quiz Maker!", "cluevo"); ?></p>
  <p><?php esc_html_e(
      "One of the most requested features has always been the ability to create learning content with CLUEVO. The time has finally come!",
      "cluevo"
  ); ?></p>
  <p><?php esc_html_e(
      "We've been hard at work on our very own AI quiz maker. Our AI quiz creator transforms your WordPress posts into multiple-choice quizzes, ready to be used with your learning management system",
      "cluevo"
  ); ?></p>
  <a href="https://wp-lms.cluevo.at/pricing" class="cluevo-extension-link-button"><span class="dashicons dashicons-external"></span> <?php esc_html_e(
      "Extension Store",
      "cluevo"
  ); ?></a>
  <h2><?php esc_html_e(
      "Step #1 - Select a post or create a new one",
      "cluevo"
  ); ?></h2>
  <p><?php esc_html_e(
      "You can either select one of your existing posts or pages or quickly create an ad-hoc quiz post by pasting any content into the quiz maker.",
      "cluevo"
  ); ?></p>
  <p><img src="<?php echo cluevo_get_conf_const("CLUEVO_IMAGE_URL") .
      "quiz_post_example.png"; ?>" alt="<?php esc_attr_e(
      "Select either an existing post or paste content into the wizard to create an ad-hoc quiz source post",
      "cluevo"
  ); ?>" /></p>
  <h2><?php esc_html_e(
      "Step #2 - Extract and simplify the key points",
      "cluevo"
  ); ?></h2>
  <p><?php esc_html_e(
      "Before we create your quiz we'll analyze your post and extract the key points. You can always add points in case you feel like we missed something or remove any points to think are not needed",
      "cluevo"
  ); ?></p>
  <p><img src="<?php echo cluevo_get_conf_const("CLUEVO_IMAGE_URL") .
      "quiz_key_points.png"; ?>" alt="<?php esc_attr_e(
      "Select either an existing post or paste content into the wizard to create an ad-hoc quiz source post",
      "cluevo"
  ); ?>" class="cluevo-ext-ex-image" /></p>
  <h2><?php esc_html_e("Step #3 - Create the questions!", "cluevo"); ?></h2>
  <p><?php esc_html_e(
      "The last step is to use the extracted key points to generate your quiz questions. We'll take each key point and attempt to create at least one quqestion from it.",
      "cluevo"
  ); ?></p>
  <p><img src="<?php echo cluevo_get_conf_const("CLUEVO_IMAGE_URL") .
      "quiz_questions.png"; ?>" alt="<?php esc_attr_e(
      "Select which questions you want to use",
      "cluevo"
  ); ?>" class="cluevo-ext-ex-image" /></p>
  <h2><?php esc_html_e("Aaaaand we're done!", "cluevo"); ?></h2>
  <p><?php esc_html_e(
      "At this point you've saved your questions and created your quiz. You can also create your own quizzes and use any questions you've already created.",
      "cluevo"
  ); ?></p>
  <p><img src="<?php echo cluevo_get_conf_const("CLUEVO_IMAGE_URL") .
      "quiz_done.png"; ?>" alt="<?php esc_attr_e(
      "Select which questions you want to use",
      "cluevo"
  ); ?>" /></p>
  <p><?php esc_html_e(
      "Get the AI Quiz Maker now via our Extension Store!",
      "cluevo"
  ); ?></p>
  <a href="https://wp-lms.cluevo.at/pricing" class="cluevo-extension-link-button"><span class="dashicons dashicons-external"></span> <?php esc_html_e(
      "Extension Store",
      "cluevo"
  ); ?></a>
</div>
