<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WAFで使用するルール設定用のクラス
 */
class CloudSecureWP_Waf_Rules {
	// ルールの定義
	private const WAF_RULES = array(
		array(
			'id'               => '1000101',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names', 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => '',
			'regex_pattern'    => 'sys\.user_triggers|sys\.user_objects|@@spid|msysaces|instr|sys\.user_views|sys\.tab|charindex|sys\.user_catalog|constraint_type|locate|select|msysobjects|attnotnull|sys\.user_tables|sys\.user_tab_columns|sys\.user_constraints|waitfor|mysql\.user|sys\.all_tables|msysrelationships|msyscolumns|msysqueries',
			'transformations'  => array( 'htmlentitydecode', 'lowercase', 'replacecomments', 'compresswhitespace' ),
		),
		array(
			'id'               => '1000102',
			'skip'             => 0,
			'skipafter'        => '959007',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950007',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '(?:\b(?:(?:s(?:ys\.(?:user_(?:(?:t(?:ab(?:_column|le)|rigger)|object|view)s|c(?:onstraints|atalog))|all_tables|tab)|elect\b.{0,40}\b(?:substring|ascii|user))|m(?:sys(?:(?:queri|ac)e|relationship|column|object)s|ysql\.user)|c(?:onstraint_type|harindex)|waitfor\b\W*?\bdelay|attnotnull)\b|(?:locate|instr)\W+\()|\@\@spid\b)',
			'transformations'  => array( 'htmlentitydecode', 'lowercase', 'replacecomments', 'compresswhitespace' ),
		),
		array(
			'id'               => '959007',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 1,
			'regex_pattern'    => '(?:\b(?:(?:s(?:ys\.(?:user_(?:(?:t(?:ab(?:_column|le)|rigger)|object|view)s|c(?:onstraints|atalog))|all_tables|tab)|elect\b.{0,40}\b(?:substring|ascii|user))|m(?:sys(?:(?:queri|ac)e|relationship|column|object)s|ysql\.user)|c(?:onstraint_type|harindex)|waitfor\b\W*?\bdelay|attnotnull)\b|(?:locate|instr)\W+\()|\@\@spid\b)',
			'transformations'  => array( 'htmlentitydecode', 'lowercase', 'replacecomments', 'compresswhitespace' ),
		),
		array(
			'id'               => '1000103',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => '',
			'regex_pattern'    => 'substr|xtype|textpos|all_objects|rownum|sysfilegroups|sysprocesses|user_group|sysobjects|user_tables|systables|pg_attribute|user_users|user_password|column_id|attrelid|user_tab_columns|table_name|pg_class|user_constraints|user_objects|object_type|dba_users|sysconstraints|mb_users|column_name|atttypid|object_id|substring|syscat|user_ind_columns|sysibm|syscolumns|sysdba|object_name',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000104',
			'skip'             => 0,
			'skipafter'        => '959904',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950904',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:(?:s(?:ys(?:(?:(?:process|tabl)e|filegroup|object)s|c(?:o(?:nstraint|lumn)s|at)|dba|ibm)|ubstr(?:ing)?)|user_(?:(?:(?:constrain|objec)t|tab(?:_column|le)|ind_column|user)s|password|group)|a(?:tt(?:rel|typ)id|ll_objects)|object_(?:(?:nam|typ)e|id)|pg_(?:attribute|class)|column_(?:name|id)|(?:dba|mb)_users|xtype\W+\bchar|rownum)\b|t(?:able_name\b|extpos\W+\())',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959904',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:(?:s(?:ys(?:(?:(?:process|tabl)e|filegroup|object)s|c(?:o(?:nstraint|lumn)s|at)|dba|ibm)|ubstr(?:ing)?)|user_(?:(?:(?:constrain|objec)t|tab(?:_column|le)|ind_column|user)s|password|group)|a(?:tt(?:rel|typ)id|ll_objects)|object_(?:(?:nam|typ)e|id)|pg_(?:attribute|class)|column_(?:name|id)|(?:dba|mb)_users|xtype\W+\bchar|rownum)\b|t(?:able_name\b|extpos\W+\())',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000105',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names', 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => '',
			'regex_pattern'    => 'insert|xp_enumdsn|infile|openrowset|nvarchar|autonomous_transaction|print|data_type|or|outfile|inner|shutdown|tbcreator|@@version|xp_filelist|sp_prepare|sql_longvarchar|xp_regenumkeys|xp_loginconfig|xp_dirtree|ifnull|sp_addextendedproc|xp_regaddmultistring|delete|sp_sqlexec|and|sp_oacreate|sp_execute|cast|xp_ntsec|xp_regdeletekey|drop|varchar|xp_execresultset|having|utl_file|xp_regenumvalues|xp_terminate|xp_availablemedia|xp_regdeletevalue|dumpfile|isnull|sql_variant|select|\'sa\'|xp_regremovemultistring|xp_makecab|\'msdasql\'|xp_cmdshell|openquery|sp_executesql|\'sqloledb\'|dbms_java|\'dbo\'|utl_http|sp_makewebtask|benchmark|xp_regread|xp_regwrite',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '999501',
			'skip'             => 0,
			'skipafter'        => '959001',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950001',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '(?:\b(?:(?:s(?:elect\b(?:.{1,100}?\b(?:(?:length|count|top)\b.{1,100}?\bfrom|from\b.{1,100}?\bwhere)|.*?\b(?:d(?:ump\b.*\bfrom|ata_type)|(?:to_(?:numbe|cha)|inst)r))|p_(?:(?:addextendedpro|sqlexe)c|(?:oacreat|prepar)e|execute(?:sql)?|makewebtask)|ql_(?:longvarchar|variant))|xp_(?:reg(?:re(?:movemultistring|ad)|delete(?:value|key)|enum(?:value|key)s|addmultistring|write)|e(?:xecresultset|numdsn)|(?:terminat|dirtre)e|availablemedia|loginconfig|cmdshell|filelist|makecab|ntsec)|u(?:nion\b.{1,100}?\bselect|tl_(?:file|http))|group\b.*\bby\b.{1,100}?\bhaving|d(?:elete\b\W*?\bfrom|bms_java)|load\b\W*?\bdata\b.*\binfile|(?:n?varcha|tbcreato)r)\b|i(?:n(?:to\b\W*?\b(?:dump|out)file|sert\b\W*?\binto|ner\b\W*?\bjoin)\b|(?:f(?:\b\W*?\(\W*?\bbenchmark|null\b)|snull\b)\W*?\()|a(?:nd\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|utonomous_transaction\b)|o(?:r\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|pen(?:rowset|query)\b)|having\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|print\b\W*?\@\@|cast\b\W*?\()|(?:;\W*?\b(?:shutdown|drop)|\@\@version)\b|\'(?:s(?:qloledb|a)|msdasql|dbo)\')',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959001',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 1,
			'regex_pattern'    => '(?:\b(?:(?:s(?:elect\b(?:.{1,100}?\b(?:(?:length|count|top)\b.{1,100}?\bfrom|from\b.{1,100}?\bwhere)|.*?\b(?:d(?:ump\b.*\bfrom|ata_type)|(?:to_(?:numbe|cha)|inst)r))|p_(?:(?:addextendedpro|sqlexe)c|(?:oacreat|prepar)e|execute(?:sql)?|makewebtask)|ql_(?:longvarchar|variant))|xp_(?:reg(?:re(?:movemultistring|ad)|delete(?:value|key)|enum(?:value|key)s|addmultistring|write)|e(?:xecresultset|numdsn)|(?:terminat|dirtre)e|availablemedia|loginconfig|cmdshell|filelist|makecab|ntsec)|u(?:nion\b.{1,100}?\bselect|tl_(?:file|http))|group\b.*\bby\b.{1,100}?\bhaving|d(?:elete\b\W*?\bfrom|bms_java)|load\b\W*?\bdata\b.*\binfile|(?:n?varcha|tbcreato)r)\b|i(?:n(?:to\b\W*?\b(?:dump|out)file|sert\b\W*?\binto|ner\b\W*?\bjoin)\b|(?:f(?:\b\W*?\(\W*?\bbenchmark|null\b)|snull\b)\W*?\()|a(?:nd\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|utonomous_transaction\b)|o(?:r\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|pen(?:rowset|query)\b)|having\b ?(?:\d{1,10}|[\'\"][^=]{1,10}[\'\"]) ?[=<>]+|print\b\W*?\@\@|cast\b\W*?\()|(?:;\W*?\b(?:shutdown|drop)|\@\@version)\b|\'(?:s(?:qloledb|a)|msdasql|dbo)\')',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '950901',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '\b(?<![\w]{1}[_\-]{1})(\d+) ?= ?\1\b|[\'\"](\w+)[\'\"] ?= ?[\'\"]\2\b',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959901',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 1,
			'regex_pattern'    => '\b(?<![\w]{1}[_\-]{1})(\d+) ?= ?\1\b|[\'\"](\w+)[\'\"] ?= ?[\'\"]\2\b',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000106',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => '',
			'regex_pattern'    => 'user_objects|object_type|substr|all_objects|mb_users|column_name|rownum|atttypid|substring|object_id|user_group|user_tables|pg_attribute|user_users|column_id|user_password|attrelid|object_name|table_name|pg_class',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000107',
			'skip'             => 0,
			'skipafter'        => '959906',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950906',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:user_(?:(?:object|table|user)s|password|group)|a(?:tt(?:rel|typ)id|ll_objects)|object_(?:(?:nam|typ)e|id)|pg_(?:attribute|class)|column_(?:name|id)|substr(?:ing)?|table_name|mb_users|rownum)\b',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959906',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:user_(?:(?:object|table|user)s|password|group)|a(?:tt(?:rel|typ)id|ll_objects)|object_(?:(?:nam|typ)e|id)|pg_(?:attribute|class)|column_(?:name|id)|substr(?:ing)?|table_name|mb_users|rownum)\b',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '950908',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:coalesce\b|root\@)',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959908',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer', 'via' ) ),
			'attack'           => 1,
			'regex_pattern'    => '\b(?:coalesce\b|root\@)',
			'transformations'  => array( 'htmlentitydecode', 'replacecomments', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000201',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names', 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => '',
			'regex_pattern'    => 'jscript|onsubmit|copyparentfolder|javascript|meta|onmove|onkeydown|onchange|onkeyup|activexobject|expression|onmouseup|ecmascript|onmouseover|vbscript:|<!\[cdata\[|http:|settimeout|onabort|shell:|\.innerhtml|onmousedown|onkeypress|asfunction:|onclick|\.fromcharcode|background-image:|\.cookie|ondragdrop|onblur|x-javascript|mocha:|onfocus|javascript:|getparentfolder|lowsrc|onresize|@import|alert|onselect|script|onmouseout|onmousemove|background|application|\.execscript|livescript:|getspecialfolder|vbscript|iframe|\.addimport|onunload|createtextrange|onload|<input',
			'transformations'  => array( 'htmlentitydecode', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '1000202',
			'skip'             => 0,
			'skipafter'        => '959004',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950004',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 2,
			'regex_pattern'    => '(?:\b(?:(?:type\b\W*?\b(?:text\b\W*?\b(?:j(?:ava)?|ecma|vb)|application\b\W*?\bx-(?:java|vb))script|c(?:opyparentfolder|reatetextrange)|get(?:special|parent)folder|iframe\b.{0,100}?\bsrc)\b|on(?:(?:mo(?:use(?:o(?:ver|ut)|down|move|up)|ve)|key(?:press|down|up)|c(?:hange|lick)|s(?:elec|ubmi)t|(?:un)?load|dragdrop|resize|focus|blur)\b\W*?=|abort\b)|(?:l(?:owsrc\b\W*?\b(?:(?:java|vb)script|shell|http)|ivescript)|(?:href|url)\b\W*?\b(?:(?:java|vb)script|shell)|background-image|mocha):|s(?:(?:tyle\b\W*=.*\bexpression\b\W*|ettimeout\b\W*?)\(|rc\b\W*?\b(?:(?:java|vb)script|shell|http):)|a(?:ctivexobject\b|lert\b\W*?\(|sfunction:))|<(?:(?:body\b.*?\b(?:backgroun|onloa)d|input\b.*?\btype\b\W*?\bimage)\b| ?(?:(?:script|meta)\b|iframe)|!\[cdata\[)|(?:\.(?:(?:execscrip|addimpor)t|(?:fromcharcod|cooki)e|innerhtml)|\@import)\b)',
			'transformations'  => array( 'htmlentitydecode', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '959004',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array( 'request_headers' => array( 'Referer' ) ),
			'attack'           => 2,
			'regex_pattern'    => '(?:\b(?:(?:type\b\W*?\b(?:text\b\W*?\b(?:j(?:ava)?|ecma|vb)|application\b\W*?\bx-(?:java|vb))script|c(?:opyparentfolder|reatetextrange)|get(?:special|parent)folder|iframe\b.{0,100}?\bsrc)\b|on(?:(?:mo(?:use(?:o(?:ver|ut)|down|move|up)|ve)|key(?:press|down|up)|c(?:hange|lick)|s(?:elec|ubmi)t|(?:un)?load|dragdrop|resize|focus|blur)\b\W*?=|abort\b)|(?:l(?:owsrc\b\W*?\b(?:(?:java|vb)script|shell|http)|ivescript)|(?:href|url)\b\W*?\b(?:(?:java|vb)script|shell)|background-image|mocha):|s(?:(?:tyle\b\W*=.*\bexpression\b\W*|ettimeout\b\W*?)\(|rc\b\W*?\b(?:(?:java|vb)script|shell|http):)|a(?:ctivexobject\b|lert\b\W*?\(|sfunction:))|<(?:(?:body\b.*?\b(?:backgroun|onloa)d|input\b.*?\btype\b\W*?\bimage)\b| ?(?:(?:script|meta)\b|iframe)|!\[cdata\[)|(?:\.(?:(?:execscrip|addimpor)t|(?:fromcharcod|cooki)e|innerhtml)|\@import)\b)',
			'transformations'  => array( 'htmlentitydecode', 'compresswhitespace', 'lowercase' ),
		),
		array(
			'id'               => '950002',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename' ),
			'remove_variables' => array(),
			'attack'           => 4,
			'regex_pattern'    => '\b(?:n(?:map|et|c)|w(?:guest|sh)|cmd(?:32)?|telnet|rcmd|ftp)\.exe\b',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000401',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'args' ),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => 'uname|wguest\.exe|\/perl|\/nasm|rcmd\.exe|nc|tclsh|\/xterm|finger|tftp|chown|\/echo|nmap\.exe|ping|\/passwd|\/chsh|ps|\/uname|telnet\.exe|\/ftp|ls|tclsh8|lsof|\/ping|echo|cmd\.exe|\/kill|python|traceroute|\/ps|perl|passwd|wsh\.exe|\/rm|\/cpp|chgrp|\/telnet|localgroup|kill|\/chgrp|\/finger|nasm|\/ls|nc\.exe|id|\/chmod|\/nc|\/g\+\+|\/id|\/chown|cmd|\/nmap|chsh|\/gcc|net\.exe|\/python|\/lsof|ftp\.exe|ftp|xterm|mail|\/mail|tracert|nmap|rm|cd|chmod|cpp|telnet|cmd32\.exe|gcc|g\+\+',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000402',
			'skip'             => 0,
			'skipafter'        => '950006',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950006',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'args' ),
			'remove_variables' => array(),
			'attack'           => 4,
			'regex_pattern'    => '(?:\b(?:(?:n(?:et(?:\b\W+?\blocalgroup|\.exe)|(?:map|c)\.exe)|t(?:racer(?:oute|t)|elnet\.exe|clsh8?|ftp)|(?:w(?:guest|sh)|rcmd|ftp)\.exe|echo\b\W*?\by+)\b|c(?:md(?:(?:32)?\.exe\b|\b\W*?\/c)|d(?:\b\W*?[\/\\\\]|\W*?\.\.)|hmod.{0,40}?\+.{0,3}x))|[\;\|\`]\W*?\b(?:(?:c(?:h(?:grp|mod|own|sh)|md|pp)|p(?:asswd|ython|erl|ing|s)|n(?:asm|map|c)|f(?:inger|tp)|(?:kil|mai)l|(?:xte)?rm|ls(?:of)?|telnet|uname|echo|id)\b|g(?:\+\+|cc\b))|\/(?:c(?:h(?:grp|mod|own|sh)|pp)|p(?:asswd|ython|erl|ing|s)|n(?:asm|map|c)|f(?:inger|tp)|(?:kil|mai)l|g(?:\+\+|cc)|(?:xte)?rm|ls(?:of)?|telnet|uname|echo|id)(?:[\'\"\|\;\`\-\s]|$))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000403',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml', 'request_cookies', 'request_cookies_names' ),
			'remove_variables' => array( 'request_headers' => array( 'Cookie', 'Referer', 'X-OS-Prefs' ) ),
			'attack'           => '',
			'regex_pattern'    => 'uname|wguest\.exe|\/perl|\/nasm|rcmd\.exe|nc|tclsh|\/xterm|finger|tftp|chown|\/echo|nmap\.exe|ping|\/passwd|\/chsh|ps|\/uname|telnet\.exe|\/ftp|ls|tclsh8|lsof|\/ping|echo|cmd\.exe|\/kill|python|traceroute|\/ps|perl|passwd|wsh\.exe|\/rm|\/cpp|chgrp|\/telnet|localgroup|kill|\/chgrp|\/finger|nasm|\/ls|nc\.exe|id|\/chmod|\/nc|\/g\+\+|\/id|\/chown|cmd|\/nmap|chsh|\/gcc|net\.exe|\/python|\/lsof|ftp\.exe|ftp|xterm|mail|\/mail|tracert|nmap|rm|cd|chmod|cpp|telnet|cmd32\.exe|gcc|g\+\+',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000404',
			'skip'             => 0,
			'skipafter'        => '959006',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '959006',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml', 'request_cookies', 'request_cookies_names' ),
			'remove_variables' => array( 'request_headers' => array( 'Cookie', 'Referer', 'X-OS-Prefs' ) ),
			'attack'           => 4,
			'regex_pattern'    => '(?:\b(?:(?:n(?:et(?:\b\W+?\blocalgroup|\.exe)|(?:map|c)\.exe)|t(?:racer(?:oute|t)|elnet\.exe|clsh8?|ftp)|(?:w(?:guest|sh)|rcmd|ftp)\.exe|echo\b\W*?\by+)\b|c(?:md(?:(?:32)?\.exe\b|\b\W*?\/c)|d(?:\b\W*?[\/\\\\]|\W*?\.\.)|hmod.{0,40}?\+.{0,3}x))|[\;\|\`]\W*?\b(?:(?:c(?:h(?:grp|mod|own|sh)|md|pp)|p(?:asswd|ython|erl|ing|s)|n(?:asm|map|c)|f(?:inger|tp)|(?:kil|mai)l|(?:xte)?rm|ls(?:of)?|telnet|uname|echo|id)\b|g(?:\+\+|cc\b))|\/(?:c(?:h(?:grp|mod|own|sh)|pp)|p(?:asswd|ython|erl|ing|s)|n(?:asm|map|c)|f(?:inger|tp)|(?:kil|mai)l|g(?:\+\+|cc)|(?:xte)?rm|ls(?:of)?|telnet|uname|echo|id)(?:[\'\"\|\;\`\-\s]|$))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '950907',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'args' ),
			'remove_variables' => array(),
			'attack'           => 4,
			'regex_pattern'    => '(?:(?:[\;\|\`]\W*?\bcc|\bwget)\b|\/cc(?:[\'\"\|\;\`\-\s]|$))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '959907',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml', 'request_cookies', 'request_cookies_names' ),
			'remove_variables' => array( 'request_headers' => array( 'Cookie', 'Referer', 'X-OS-Prefs', 'User-Agent' ) ),
			'attack'           => 4,
			'regex_pattern'    => '(?:(?:[\;\|\`]\W*?\bcc|\bwget)\b|\/cc(?:[\'\"\|\;\`\-\s]|$))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000501',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names', 'request_headers', 'xml' ),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '<\?fgets|move_uploaded_file|\$_session|readfile|ftp_put|ftp_fget|gzencode|ftp_nb_put|bzopen|readdir|\$_post|fopen|gzread|ftp_nb_fput|ftp_nb_fget|ftp_get|\$_get|scandir|fscanf|readgzfile|fread|proc_open|fgetc|fgetss|ftp_fput|ftp_nb_get|session_start|fwrite|gzwrite|gzopen|gzcompress',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '1000502',
			'skip'             => 0,
			'skipafter'        => '959013',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => '950013',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 8,
			'regex_pattern'    => '(?:(?:\b(?:f(?:tp_(?:nb_)?f?(?:ge|pu)t|get(?:s?s|c)|scanf|write|open|read)|gz(?:(?:encod|writ)e|compress|open|read)|s(?:ession_start|candir)|read(?:(?:gz)?file|dir)|move_uploaded_file|(?:proc_|bz)open)|\$_(?:(?:pos|ge)t|session))\b|<\?(?!xml))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '959013',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array(),
			'attack'           => 8,
			'regex_pattern'    => '(?:(?:\b(?:f(?:tp_(?:nb_)?f?(?:ge|pu)t|get(?:s?s|c)|scanf|write|open|read)|gz(?:(?:encod|writ)e|compress|open|read)|s(?:ession_start|candir)|read(?:(?:gz)?file|dir)|move_uploaded_file|(?:proc_|bz)open)|\$_(?:(?:pos|ge)t|session))\b|<\?(?!xml))',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '950019',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_filename', 'args', 'args_names' ),
			'remove_variables' => array(),
			'attack'           => 16,
			'regex_pattern'    => '[\n\r]\s*\b(?:to|b?cc)\b\s*:.*?\@',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => '959019',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'request_headers', 'xml' ),
			'remove_variables' => array(),
			'attack'           => 16,
			'regex_pattern'    => '[\n\r]\s*\b(?:to|b?cc)\b\s*:.*?\@',
			'transformations'  => array( 'htmlentitydecode', 'lowercase' ),
		),
		array(
			'id'               => 'm333827',
			'skip'             => 1,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'args' ),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => 'php|chr|fopen|fwrite|globals|system|passthru|serialize|include|php_uname|popen|proc_open|mysql_query|exec|eval|create_function|proc_nice|proc_terminate|proc_get_status|proc_close|pfsockopen|leak|apache_child_terminate|posix_kill|posix_mkfifo|posix_setpgid|posix_setsid|posix_setuid|phpinfo|preg_|decode_base64|base64_decode|base64_url_decode|rot13|<\?|mfunc|mclude|dynamic-cached-content|md5|die|sha',
			'transformations'  => array(),
		),
		array(
			'id'               => 'm334377',
			'skip'             => 0,
			'skipafter'        => 'm340095',
			'chain'            => false,
			'variables'        => array(),
			'remove_variables' => array(),
			'attack'           => '',
			'regex_pattern'    => '',
			'transformations'  => array(),
		),
		array(
			'id'               => 'm340095',
			'skip'             => 0,
			'skipafter'        => '',
			'chain'            => false,
			'variables'        => array( 'args' ),
			'remove_variables' => array( 'args' => array( 'wpSummary', 'post_content' ) ),
			'attack'           => 8,
			'regex_pattern'    => '(?:\b(?:eval|rot13|strrev|passthru|serialize|php(?:_uname|info)|(?:preg|zlib)_\w+|mysql_query|(?:shell_)?exec|base64_(?:url_)?decode|create_function|decode_base64|gzinflate|gzdecode|gzuncompress)\b\s?(?:\(|\:)|\(chr\s?\(\s?[0-9]{1,3}\s?\)|\s?=\s?(?:fopen|fwrite)\s?\(|\b(?:system|include)\b\s?\((?:\'|\"|\$)|<\s?\?\s?=\s?system\s?\(\s?\$_|die\(\@md5|die\(\@sha)',
			'transformations'  => array( 'lowercase' ),
		),
	);


	private const LOCATIONMATCH_RULES = array(
		array(
			'path'            => '\/wp-admin\/(setup-config|install|profile|user-edit|user-new|post|admin-ajax|nav-menus|options|options-permalink|load-scripts|load-style)\.php',
			'remove_rule_ids' => array( '950004', '959004', '1000201', '1000202' ),
		),
		array(
			'path'            => 'wp-login\.php\?vaultpress=true',
			'remove_rule_ids' => array( 'm340095' ),
		),
	);


	/**
	 * ルールの取得
	 *
	 * @return array
	 */
	public function get_waf_rules(): array {
		return self::WAF_RULES;
	}

	/**
	 * LocationMatchルールの取得
	 *
	 * @return array
	 */
	public function get_locationmatch_rules(): array {
		return self::LOCATIONMATCH_RULES;
	}
}

