<?php

namespace Cloudflare\APO\Integration;

use Cloudflare\APO\Vendor\Psr\Log\AbstractLogger;
use Cloudflare\APO\Vendor\Psr\Log\LogLevel;
use Cloudflare\APO\Vendor\Psr\Log\LoggerInterface;

class DefaultLogger extends AbstractLogger implements LoggerInterface
{
    private $debug;

    const PREFIX = '[Cloudflare]';

    /**
     * @param bool|false $debug
     */
    public function __construct($debug = false)
    {
        $this->debug = $debug;
    }

    /**
     * Logs with an arbitrary level.
     *
     * @param mixed  $level
     * @param string $message
     * @param array  $context
     */
    public function log($level, $message, array $context = array())
    {
        return error_log(self::PREFIX.' '.strtoupper($level).': '.$message.' '.
            (!empty($context) ? print_r($context, true) : ''));
    }

    /**
     * Detailed debug information.
     *
     * @param string $message
     * @param array  $context
     */
    public function debug($message, array $context = array())
    {
        if ($this->debug) {
            return $this->log(LogLevel::DEBUG, $message, $context);
        }
    }
}
