<?php
/**
 * Settings.php
 *
 * @package  Conexa\ClipTransparent\Gateway\
 */

namespace Conexa\ClipTransparent\Gateway;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Conexa\ClipTransparent\Includes\Helper\Helper;

/**
 * Init form fields
 *
 * @since 0.0.1
 */
return apply_filters(
	'wc_clip_transparent_form_fields',
	array(
		'enabled'                                => array(
            'title'   => __( 'Enable/Disable', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'    => 'checkbox',
            'label'   => __( 'Enable clip transparent Payment Gateway', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'default' => 'yes',
		),

		'wc_clip_credentials_subtitle'           => array(
			'title'       => '',
			'type'        => 'title',
            'description' => __( "If you still do not have your credentials to operate with Clip, click <a href='https://dashboard.developer.clip.mx/' target='_bank'>here</a>.", 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
		),

		'wc_clip_transparent_api_key'             => array(
            'title' => __( 'Client Api Key', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'  => 'text',
		),

		'wc_clip_transparent_api_secret'          => array(
            'title' => __( 'Client Api Secret', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'  => 'password',
		),

		'wc_clip_transparent_validations_section' => array(
            'title'       => __( 'Validation', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'        => 'title',
			'description' => Helper::validate_all_html(),
		),

		'wc_clip_transparent_theme_options'       => array(
            'title'   => __( 'Theme Options', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'    => 'select',
			'default' => 'default',
			'options' => array(
                'eco'     => __( 'Eco', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
                'dark'    => __( 'Dark', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
                'default' => __( 'Default', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			),
		),

		'wc_clip_transparent_locale_options'      => array(
            'title'   => __( 'Locale Options', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'    => 'select',
			'default' => 'es',
			'options' => array(
                'en' => __( 'English', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
                'es' => __( 'Spanish', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			),
		),

		'wc_clip_transparent_log_enabled'         => array(
            'title'       => __( 'Enable/Disable', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'type'        => 'checkbox',
            'label'       => __( 'Activate Logs', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
			'description' => sprintf(
			/* translators: %s: System Flag */
                __(
                    'You can enable plugin debugging to track communication between the plugin and clip transparent API. You will be able to view the record from the <a href="%s">WooCommerce > Status > Records</a> menu.',
                    'clip-mexico-payments-for-ecommerce-transparent-checkout'
                ),
				esc_url( get_admin_url( null, 'admin.php?page=wc-status&tab=logs' ) )
			),
			'default'     => 'yes',
		),
	)
);
