<?php
/**
 * Class UpdateCartTotal
 *
 * @package  Conexa\ClipTransparent\Gateway;
 */

namespace Conexa\ClipTransparent\Gateway;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Conexa\ClipTransparent\Includes\Helper\Helper;

/**
 * Update Cart Total
 */
abstract class UpdateCartTotal {

	/**
	 * Amount.
	 *
	 * @var float $amount amount.
	 */
	protected static $amount;

	/**
	 * Run Action
	 *
	 * @return bool
	 */
	public static function run() {

		if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'wc-clip_transparent' ) ) {
			wp_send_json_error( array( 'error_description' => 'Invalid nonce' ) );
			return false;
		}

		$amount = WC()->cart->total;
		wp_send_json_success( $amount );
		return true;
	}

	/**
	 * AJAX callback for WordPress
	 */
	public static function clip_transparent_cart_total() {
		self::run();
	}
}
