<?php
/**
 * Class ThreeDSComplete
 *
 * @package  Conexa\ClipTransparent\Gateway;
 */

namespace Conexa\ClipTransparent\Gateway;

use Conexa\ClipTransparent\Includes\Helper\Helper;
use Conexa\ClipTransparent\Sdk\ClipTransparentSdk;

defined( 'ABSPATH' ) || exit();

/**
 * Three DS Complete Controller
 */
class ThreeDSComplete {

	/**
	 * Get Data
	 *
	 * @return bool
	 */
	public static function get_data() {
		$data = array();

		// Sanitize and validate nonce.
		if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'wc-clip_transparent' ) ) {
			wp_send_json_error( array( 'error_description' => 'Invalid nonce' ) );
			return false;
		}

		// Sanitize and validate order_id.
		if ( isset( $_POST['order_id'] ) ) {
			$order_id = absint( $_POST['order_id'] );
			if ( $order_id > 0 ) {
				$data['order'] = wc_get_order( $order_id );
			}
		}

		// Sanitize payment_id.
		if ( isset( $_POST['payment_id'] ) ) {
			$data['payment_id'] = sanitize_text_field( wp_unslash( $_POST['payment_id'] ) );
		}

		if ( ! empty( $data ) ) {
			return $data;
		}

		return false;
	}

	/**
	 * Complete Transparent
	 *
	 * @return void
	 */
	public static function clip_transparent_3ds_complete() {
		$data  = self::get_data();
		$order = isset( $data['order'] ) ? $data['order'] : null;

		if ( $order ) {

			$sdk      = new ClipTransparentSdk( Helper::get_option( 'api_key' ), Helper::get_option( 'api_secret' ) );
			$response = $sdk->get_charge_payment( $data['payment_id'] );

			if ( isset( $response['status'] ) && 'approved' === $response['status'] ) {

				$order->payment_complete();

				$receipt_no = isset( $response['receipt_no'] ) ? $response['receipt_no'] : '';
				if ( ! empty( $receipt_no ) ) {
					$order->add_order_note(
						sprintf(
							/* translators: %s: System Flag */
                            esc_html__( 'Clip Transparent - Approved Payment. Receipt: %1$s. ID %2$s', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
							$receipt_no,
							$response['id']
						)
					);
				}

				$order->save();

				$order_received_url = wc_get_endpoint_url( 'order-received', $order->get_id(), wc_get_checkout_url() );
				$order_received_url = add_query_arg( 'key', $order->get_order_key(), $order_received_url );

				// DONE! Redirect to Thank you page.
				wp_send_json_success( array( 'redirect' => $order_received_url ) );

			} else {

				$order->update_meta_data( \ClipTransparent::CLIPTRANSP_META_ORDER_3DS_URL, '' );
				$order->save();
				$payment_nonce      = wp_create_nonce( \ClipTransparent::CLIPTRANSP_GATEWAY_ID );
				$order_received_url = add_query_arg( 'clip_transparent_nonce', $payment_nonce, add_query_arg( 'clip_transparent_3ds', true, $order->get_checkout_payment_url( true ) ) );
				wp_send_json_success( array( 'redirect' => $order_received_url ) );

			}
		}
		wp_send_json_error( 'not order' );
	}
}
