<?php
/**
 * Class ThreeDSCheckout
 *
 * @package  Conexa\ClipTransparent\Gateway;
 */

namespace Conexa\ClipTransparent\Gateway;

use Conexa\ClipTransparent\Includes\Helper\Helper;

defined( 'ABSPATH' ) || exit();

/**
 * Three DS Checkout Controller
 */
class ThreeDSCheckout {


	/**
	 * Run Action
	 *
	 * @param int $order_id ID for WC Order.
	 *
	 * @return bool
	 */
	public static function render( $order_id ) {

		$error = false;
		$order = wc_get_order( $order_id );

		if ( ! isset( $_GET['clip_transparent_nonce'] ) ) {
			$error = true;
		}

		if ( isset( $_GET['clip_transparent_nonce'] ) && ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['clip_transparent_nonce'] ) ), \ClipTransparent::CLIPTRANSP_GATEWAY_ID ) ) {
			$error = true;
		}

		if ( \ClipTransparent::CLIPTRANSP_GATEWAY_ID !== $order->get_payment_method() ) {
			$error = true;
		}

		if ( $error ) {
			return false;
		}

		$pending_action_url = $order->get_meta( \ClipTransparent::CLIPTRANSP_META_ORDER_3DS_URL );
		$decodedUrl         = htmlspecialchars_decode( $pending_action_url );
		$threeds            = \ClipTransparent::get_url( 'three_ds' );

		if ( isset( $pending_action_url ) && ! empty( $pending_action_url ) ) {

			// Enqueue 3DS CSS.
			wp_enqueue_style(
				'clip-transparent-3ds',
				Helper::get_assets_folder_url() . '/css/clip-transparent-3ds.css',
				array(),
				\ClipTransparent::CLIPTRANSP_VERSION
			);

			echo '<div class="clip-3ds-container">';
			echo '<iframe id="cybersourceIframe" class="clip-3ds-iframe" title="cybersource3Ds" src="' . esc_url( $decodedUrl ) . '" data-testid="cybersource3Ds-iframe" allowfullscreen></iframe>';
			echo '</div>';

			wp_register_script(
				'clip-transparent-checkout',
				Helper::get_assets_folder_url() . '/js/clip-transparent-checkout.js',
				array( 'jquery' ),
				\ClipTransparent::CLIPTRANSP_VERSION,
				true
			);
			wp_enqueue_script( 'clip-transparent-checkout' );

			wp_localize_script(
				'clip-transparent-checkout',
				'clip_transparent_object',
				array(
					'nonce'      => wp_create_nonce( 'wc-clip_transparent' ),
					'admin_ajax' => esc_url( admin_url( 'admin-ajax.php' ) ),
					'threeds'    => $threeds,
					'order_id'   => $order_id,
					'mode'       => \ClipTransparent::CLIPTRANSP_MODE,
				)
			);

		} else {
			?>
            <p> <?php echo esc_html__( 'An error occurs while processing your request', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ); ?></p>
			<a id="select-gateway" class="button btn btn-secondary" href="<?php echo esc_url( wc_get_checkout_url() ); ?>">
				<span>
                    <?php echo esc_html__( 'Select another payment method', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ); ?>
				</span>
			</a>
			<?php
		}
		return true;
	}
}
