<?php
/**
 * Class Clip Transparent Api Class
 *
 * @package  Conexa\ClipTransparent\Api;
 */

namespace Conexa\ClipTransparent\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Conexa\ClipTransparent\Includes\Api\ApiConnector;
use Conexa\ClipTransparent\Includes\Api\ApiInterface;

/**
 * Clip Transparent API Class
 */
class ClipTransparentApi extends ApiConnector implements ApiInterface {
	/**
	 * Get Base API Url
	 *
	 * @return string
	 */
	public function get_base_url() {
		return \ClipTransparent::get_url( 'backend' );
	}

	/**
	 * Get Refund Base Url
	 *
	 * @return string
	 */
	public function get_refund_base_url() {
		return \ClipTransparent::get_url( 'refund' );
	}

	/**
	 * Get Validate Base Url
	 *
	 * @return string
	 */
	public function get_validate_base_url() {
		return \ClipTransparent::get_url( 'validate' );
	}
}
