<?php
/**
 * Class ValidationsTrait
 *
 * @package  Conexa\ClipTransparent\Helper\ValidationsTrait
 */

namespace Conexa\ClipTransparent\Includes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Conexa\ClipTransparent\Sdk\ClipTransparentSdk;
use Conexa\ClipTransparent\Gateway\WC_ClipTransparent;
/**
 * Validations Trait
 */
trait ValidationsTrait {

	/**
	 * Validate HTML
	 *
	 * @param bool   $check_target Value to test.
	 * @param string $message_ok Message to show if $bool is true.
	 * @param string $message_error Message to show if $bool is false.
	 *
	 * @return Array
	 */
	public static function validate_html( $check_target, $message_ok, $message_error ) {
		return $check_target
			? self::CLIPTRANSP_VALIDATION_OK_ICON . $message_ok
			: self::CLIPTRANSP_VALIDATION_ERROR_ICON . $message_error;
	}

	/**
	 * Validate Credentials
	 *
	 * @return bool
	 */
	public static function validate_credentials() {

		$sdk = new ClipTransparentSdk(
			self::get_option( 'api_key' ),
			self::get_option( 'api_secret' )
		);

		return $sdk->validate_key();
	}

	/**
	 * Validate Credentials HTML
	 *
	 * @return bool
	 */
	public static function validate_credentials_html() {
		return self::validate_html(
			self::validate_credentials(),
            __( 'Valid credentials.', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),
            __( 'Invalid credentials.', 'clip-mexico-payments-for-ecommerce-transparent-checkout' )
		);
	}

	/**
	 * Validations All Html (print erros)
	 *
	 * @return string
	 */
	public static function validate_all_html() {
		global $current_section;
		if ( 'wc_clip_transparent' === $current_section ) {
			return '<p>' . self::validate_credentials_html() . '</p>';
		}
		return '';
	}
}
